#include "mex.h"
#include "matrix.h"
#include "math.h"
#include "stdio.h"

void mexFunction( int nlhs, mxArray *plhs[],
                  int nrhs, const mxArray *prhs[] )

{

    /* -- Inputs -- */
	double *nin			= mxGetPr(prhs[0]);
	double *nxin		= mxGetPr(prhs[1]);
	double *nyin		= mxGetPr(prhs[2]);
	double *xss 		= mxGetPr(prhs[3]);
    double *yss 		= mxGetPr(prhs[4]);
	double *parmin 		= mxGetPr(prhs[5]);
	double *nnuin 		= mxGetPr(prhs[6]);
	double *varphiin	= mxGetPr(prhs[7]);
	double *Hs  		= mxGetPr(prhs[8]);
	double *Gs 			= mxGetPr(prhs[9]);
	double *Gsp 		= mxGetPr(prhs[10]);
	double *G2sp 		= mxGetPr(prhs[11]);
	double *Psspin  	= mxGetPr(prhs[12]);
	double *dP1sspin	= mxGetPr(prhs[13]);
	double *dP2sspin	= mxGetPr(prhs[14]);


	/* -- Specific Inputs -- */
	int n 				= nin[0];
	int nx 				= nxin[0];
	int ny 				= nyin[0];
	double nnus 		= nnuin[0];
	double varphis		= varphiin[0];
	double bbeta 		= parmin[0];
	double rrho 		= parmin[1];
	double oomega 		= parmin[2];
	double eeta 		= parmin[3];
	double aalpha 		= parmin[4];
	double ddelta 		= parmin[5];
	double pbar 		= parmin[6];
	double ebar 		= parmin[7];
	double iiota 		= parmin[8];
	double pphi 		= parmin[9];
	double rbar 		= parmin[10];
	double kkappa   	= parmin[11];
	double rrhoa 		= parmin[12];
	double rrhoz 		= parmin[13];
	double rrhop 		= parmin[14];
	double rrhor 		= parmin[15];
	double rrhoe 		= parmin[16];
	double rrhod 	 	= parmin[17];
	double varphibar 	= parmin[18];
	double bbar 		= parmin[19];
	double ppsir 		= parmin[20];
	double abar  		= parmin[21];
	double zbar 		= parmin[22];
	double Pssp 		= Psspin[0];
	double dP1ssp 		= dP1sspin[0];
	double dP2ssp 		= dP2sspin[0];

	/* -- Outputs -- */
	plhs[0] = mxCreateDoubleMatrix(n*nx,(n+ny)*nx,mxREAL);
	plhs[1] = mxCreateDoubleMatrix(n*nx,1,mxREAL);
	double *Mxc_sp_s = mxGetPr(plhs[0]);
	double *Nxc_sp_s = mxGetPr(plhs[1]);

    /* -- Definition of Variables -- */
    double E = 2.71828182845905;


    /* -- Mathematica Output Here -- */
	Mxc_sp_s[1344]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxc_sp_s[12288]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxc_sp_s[12480]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxc_sp_s[13824]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[14016]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[14208]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[385]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[577]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[769]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[12481]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[12673]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[13249]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxc_sp_s[13825]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxc_sp_s[14017]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[14209]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[386]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[578]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[12482]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[12674]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[13250]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxc_sp_s[13634]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[13826]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxc_sp_s[14018]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[14210]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[3]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[195]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[387]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[579]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxc_sp_s[771]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[963]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[1155]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[1347]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[13251]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxc_sp_s[13827]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[14019]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxc_sp_s[14211]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxc_sp_s[38403]=(bbeta*pow(E,yss[8])*Pssp*Hs[0]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[41475]=(bbeta*pow(E,yss[8])*Pssp*Hs[1]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[44547]=(bbeta*pow(E,yss[8])*Pssp*Hs[2]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[47619]=(bbeta*pow(E,yss[8])*Pssp*Hs[3]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[50691]=(bbeta*pow(E,yss[8])*Pssp*Hs[4]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[53763]=(bbeta*pow(E,yss[8])*Pssp*Hs[5]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[56835]=(bbeta*pow(E,yss[8])*Pssp*Hs[6]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[59907]=(bbeta*pow(E,yss[8])*Pssp*Hs[7]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[4]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxc_sp_s[196]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxc_sp_s[388]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxc_sp_s[580]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxc_sp_s[772]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxc_sp_s[964]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxc_sp_s[1156]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxc_sp_s[1348]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxc_sp_s[13444]=-(kkappa*Pssp*yss[9]);
	Mxc_sp_s[13828]=pow(E,yss[8])*Pssp;
	Mxc_sp_s[14020]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxc_sp_s[14212]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxc_sp_s[37060]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]);
	Mxc_sp_s[37252]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0];
	Mxc_sp_s[37636]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]);
	Mxc_sp_s[38404]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[0])/pow(zbar,rrho);
	Mxc_sp_s[40132]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[1]);
	Mxc_sp_s[40324]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[1];
	Mxc_sp_s[40708]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[1]);
	Mxc_sp_s[41476]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[1])/pow(zbar,rrho);
	Mxc_sp_s[43204]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[2]);
	Mxc_sp_s[43396]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[2];
	Mxc_sp_s[43780]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[2]);
	Mxc_sp_s[44548]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[2])/pow(zbar,rrho);
	Mxc_sp_s[46276]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[3]);
	Mxc_sp_s[46468]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[3];
	Mxc_sp_s[46852]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[3]);
	Mxc_sp_s[47620]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[3])/pow(zbar,rrho);
	Mxc_sp_s[49348]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[4]);
	Mxc_sp_s[49540]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[4];
	Mxc_sp_s[49924]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[4]);
	Mxc_sp_s[50692]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[4])/pow(zbar,rrho);
	Mxc_sp_s[52420]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[5]);
	Mxc_sp_s[52612]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[5];
	Mxc_sp_s[52996]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[5]);
	Mxc_sp_s[53764]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[5])/pow(zbar,rrho);
	Mxc_sp_s[55492]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[6]);
	Mxc_sp_s[55684]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[6];
	Mxc_sp_s[56068]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[6]);
	Mxc_sp_s[56836]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[6])/pow(zbar,rrho);
	Mxc_sp_s[58564]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[7]);
	Mxc_sp_s[58756]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[7];
	Mxc_sp_s[59140]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[7]);
	Mxc_sp_s[59908]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[7])/pow(zbar,rrho);
	Mxc_sp_s[5]=iiota*Pssp*zbar;
	Mxc_sp_s[581]=iiota*Pssp*zbar;
	Mxc_sp_s[13445]=-Pssp;
	Mxc_sp_s[12486]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxc_sp_s[13638]=-(pow(E,yss[7])*Pssp);
	Mxc_sp_s[14022]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[14214]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[199]=-((Pssp*zbar)/(1 + yss[5]));
	Mxc_sp_s[391]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[583]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxc_sp_s[775]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxc_sp_s[1159]=-(pow(E,yss[11])*ebar*Pssp);
	Mxc_sp_s[12295]=-(pow(E,yss[0])*Pssp);
	Mxc_sp_s[12487]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxc_sp_s[12679]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxc_sp_s[12871]=-(pow(E,yss[3])*Pssp);
	Mxc_sp_s[13255]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[13639]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxc_sp_s[14023]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[14215]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[8]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[584]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[12872]=pow(E,yss[3])*Pssp;
	Mxc_sp_s[14024]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[14216]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[9]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[201]=(Pssp*zbar)/(1 + yss[5]);
	Mxc_sp_s[585]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxc_sp_s[777]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[12489]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[12681]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[13257]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[13449]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[13641]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[14025]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[14217]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[14026]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[14218]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[203]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxc_sp_s[971]=Pssp;
	Mxc_sp_s[13259]=-Pssp;
	Mxc_sp_s[14027]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[14219]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[12]=pow(E,xss[0])*Pssp;
	Mxc_sp_s[13068]=-(pow(E,xss[0])*Pssp);
	Mxc_sp_s[397]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[589]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[781]=pow(E,yss[2])*pbar*Pssp;
	Mxc_sp_s[12493]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[12685]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxc_sp_s[14029]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[14221]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[14413]=pow(E,yss[11])*Pssp;
	Mxc_sp_s[206]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[590]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[14030]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[14222]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[14414]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[14606]=Pssp;
	Mxc_sp_s[207]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[591]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[14031]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[14223]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[14415]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[14799]=Pssp;
	Mxc_sp_s[1168]=ebar*Pssp;
	Mxc_sp_s[12304]=pow(E,yss[0] - yss[11])*Pssp;
	Mxc_sp_s[12880]=pow(E,yss[3] - yss[11])*Pssp;
	Mxc_sp_s[14032]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[14224]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[14416]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxc_sp_s[14992]=Pssp;
	Mxc_sp_s[17]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[209]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[401]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[593]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxc_sp_s[785]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[977]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[1169]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[1361]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[14033]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[14225]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[15185]=Pssp;
	Mxc_sp_s[38417]=(Pssp*pow(zbar,rrho)*Hs[0]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[41489]=(Pssp*pow(zbar,rrho)*Hs[1]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[44561]=(Pssp*pow(zbar,rrho)*Hs[2]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[47633]=(Pssp*pow(zbar,rrho)*Hs[3]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[50705]=(Pssp*pow(zbar,rrho)*Hs[4]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[53777]=(Pssp*pow(zbar,rrho)*Hs[5]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[56849]=(Pssp*pow(zbar,rrho)*Hs[6]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[59921]=(Pssp*pow(zbar,rrho)*Hs[7]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[402]=-Pssp;
	Mxc_sp_s[595]=-Pssp;
	Mxc_sp_s[788]=-Pssp;
	Mxc_sp_s[1365]=-Pssp;
	Mxc_sp_s[1174]=-Pssp;
	Mxc_sp_s[983]=-Pssp;
	Mxc_sp_s[2904]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxc_sp_s[15384]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxc_sp_s[15576]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxc_sp_s[16920]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[17112]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[17304]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[1945]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[2137]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[2329]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[15577]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[15769]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[16345]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxc_sp_s[16921]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxc_sp_s[17113]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[17305]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[1946]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[2138]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[15578]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[15770]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[16346]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxc_sp_s[16730]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[16922]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxc_sp_s[17114]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[17306]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[1563]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[1755]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[1947]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[2139]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxc_sp_s[2331]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[2523]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[2715]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[2907]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[16347]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxc_sp_s[16923]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[17115]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxc_sp_s[17307]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxc_sp_s[38427]=(bbeta*pow(E,yss[8])*Pssp*Hs[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[41499]=(bbeta*pow(E,yss[8])*Pssp*Hs[9]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[44571]=(bbeta*pow(E,yss[8])*Pssp*Hs[10]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[47643]=(bbeta*pow(E,yss[8])*Pssp*Hs[11]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[50715]=(bbeta*pow(E,yss[8])*Pssp*Hs[12]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[53787]=(bbeta*pow(E,yss[8])*Pssp*Hs[13]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[56859]=(bbeta*pow(E,yss[8])*Pssp*Hs[14]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[59931]=(bbeta*pow(E,yss[8])*Pssp*Hs[15]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[1564]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxc_sp_s[1756]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxc_sp_s[1948]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxc_sp_s[2140]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxc_sp_s[2332]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxc_sp_s[2524]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxc_sp_s[2716]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxc_sp_s[2908]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxc_sp_s[16540]=-(kkappa*Pssp*yss[9]);
	Mxc_sp_s[16924]=pow(E,yss[8])*Pssp;
	Mxc_sp_s[17116]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxc_sp_s[17308]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxc_sp_s[37084]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]);
	Mxc_sp_s[37276]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8];
	Mxc_sp_s[37660]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]);
	Mxc_sp_s[38428]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[8])/pow(zbar,rrho);
	Mxc_sp_s[40156]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[9]);
	Mxc_sp_s[40348]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[9];
	Mxc_sp_s[40732]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[9]);
	Mxc_sp_s[41500]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[9])/pow(zbar,rrho);
	Mxc_sp_s[43228]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[10]);
	Mxc_sp_s[43420]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[10];
	Mxc_sp_s[43804]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[10]);
	Mxc_sp_s[44572]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[10])/pow(zbar,rrho);
	Mxc_sp_s[46300]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[11]);
	Mxc_sp_s[46492]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[11];
	Mxc_sp_s[46876]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[11]);
	Mxc_sp_s[47644]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[11])/pow(zbar,rrho);
	Mxc_sp_s[49372]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[12]);
	Mxc_sp_s[49564]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[12];
	Mxc_sp_s[49948]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[12]);
	Mxc_sp_s[50716]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[12])/pow(zbar,rrho);
	Mxc_sp_s[52444]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[13]);
	Mxc_sp_s[52636]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[13];
	Mxc_sp_s[53020]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[13]);
	Mxc_sp_s[53788]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[13])/pow(zbar,rrho);
	Mxc_sp_s[55516]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[14]);
	Mxc_sp_s[55708]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[14];
	Mxc_sp_s[56092]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[14]);
	Mxc_sp_s[56860]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[14])/pow(zbar,rrho);
	Mxc_sp_s[58588]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[15]);
	Mxc_sp_s[58780]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[15];
	Mxc_sp_s[59164]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[15]);
	Mxc_sp_s[59932]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[15])/pow(zbar,rrho);
	Mxc_sp_s[1565]=iiota*Pssp*zbar;
	Mxc_sp_s[2141]=iiota*Pssp*zbar;
	Mxc_sp_s[16541]=-Pssp;
	Mxc_sp_s[15582]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxc_sp_s[16734]=-(pow(E,yss[7])*Pssp);
	Mxc_sp_s[17118]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[17310]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[1759]=-((Pssp*zbar)/(1 + yss[5]));
	Mxc_sp_s[1951]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[2143]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxc_sp_s[2335]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxc_sp_s[2719]=-(pow(E,yss[11])*ebar*Pssp);
	Mxc_sp_s[15391]=-(pow(E,yss[0])*Pssp);
	Mxc_sp_s[15583]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxc_sp_s[15775]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxc_sp_s[15967]=-(pow(E,yss[3])*Pssp);
	Mxc_sp_s[16351]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[16735]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxc_sp_s[17119]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[17311]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[1568]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[2144]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[15968]=pow(E,yss[3])*Pssp;
	Mxc_sp_s[17120]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[17312]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[1569]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[1761]=(Pssp*zbar)/(1 + yss[5]);
	Mxc_sp_s[2145]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxc_sp_s[2337]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[15585]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[15777]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[16353]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[16545]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[16737]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[17121]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[17313]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[17122]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[17314]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[1763]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxc_sp_s[2531]=Pssp;
	Mxc_sp_s[16355]=-Pssp;
	Mxc_sp_s[17123]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[17315]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[1572]=pow(E,xss[0])*Pssp;
	Mxc_sp_s[16164]=-(pow(E,xss[0])*Pssp);
	Mxc_sp_s[1957]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[2149]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[2341]=pow(E,yss[2])*pbar*Pssp;
	Mxc_sp_s[15589]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[15781]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxc_sp_s[17125]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[17317]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[17509]=pow(E,yss[11])*Pssp;
	Mxc_sp_s[1766]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[2150]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[17126]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[17318]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[17510]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[17702]=Pssp;
	Mxc_sp_s[1767]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[2151]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[17127]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[17319]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[17511]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[17895]=Pssp;
	Mxc_sp_s[2728]=ebar*Pssp;
	Mxc_sp_s[15400]=pow(E,yss[0] - yss[11])*Pssp;
	Mxc_sp_s[15976]=pow(E,yss[3] - yss[11])*Pssp;
	Mxc_sp_s[17128]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[17320]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[17512]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxc_sp_s[18088]=Pssp;
	Mxc_sp_s[1577]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[1769]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[1961]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[2153]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxc_sp_s[2345]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[2537]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[2729]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[2921]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[17129]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[17321]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[18281]=Pssp;
	Mxc_sp_s[38441]=(Pssp*pow(zbar,rrho)*Hs[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[41513]=(Pssp*pow(zbar,rrho)*Hs[9]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[44585]=(Pssp*pow(zbar,rrho)*Hs[10]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[47657]=(Pssp*pow(zbar,rrho)*Hs[11]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[50729]=(Pssp*pow(zbar,rrho)*Hs[12]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[53801]=(Pssp*pow(zbar,rrho)*Hs[13]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[56873]=(Pssp*pow(zbar,rrho)*Hs[14]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[59945]=(Pssp*pow(zbar,rrho)*Hs[15]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[1962]=-Pssp;
	Mxc_sp_s[2155]=-Pssp;
	Mxc_sp_s[2348]=-Pssp;
	Mxc_sp_s[2925]=-Pssp;
	Mxc_sp_s[2734]=-Pssp;
	Mxc_sp_s[2543]=-Pssp;
	Mxc_sp_s[4464]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxc_sp_s[18480]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxc_sp_s[18672]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxc_sp_s[20016]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[20208]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[20400]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[3505]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[3697]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[3889]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[18673]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[18865]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[19441]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxc_sp_s[20017]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxc_sp_s[20209]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[20401]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[3506]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[3698]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[18674]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[18866]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[19442]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxc_sp_s[19826]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[20018]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxc_sp_s[20210]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[20402]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[3123]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[3315]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[3507]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[3699]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxc_sp_s[3891]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[4083]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[4275]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[4467]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[19443]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxc_sp_s[20019]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[20211]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxc_sp_s[20403]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxc_sp_s[38451]=(bbeta*pow(E,yss[8])*Pssp*Hs[16]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[41523]=(bbeta*pow(E,yss[8])*Pssp*Hs[17]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[44595]=(bbeta*pow(E,yss[8])*Pssp*Hs[18]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[47667]=(bbeta*pow(E,yss[8])*Pssp*Hs[19]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[50739]=(bbeta*pow(E,yss[8])*Pssp*Hs[20]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[53811]=(bbeta*pow(E,yss[8])*Pssp*Hs[21]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[56883]=(bbeta*pow(E,yss[8])*Pssp*Hs[22]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[59955]=(bbeta*pow(E,yss[8])*Pssp*Hs[23]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[3124]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxc_sp_s[3316]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxc_sp_s[3508]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxc_sp_s[3700]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxc_sp_s[3892]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxc_sp_s[4084]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxc_sp_s[4276]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxc_sp_s[4468]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxc_sp_s[19636]=-(kkappa*Pssp*yss[9]);
	Mxc_sp_s[20020]=pow(E,yss[8])*Pssp;
	Mxc_sp_s[20212]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxc_sp_s[20404]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxc_sp_s[37108]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]);
	Mxc_sp_s[37300]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16];
	Mxc_sp_s[37684]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]);
	Mxc_sp_s[38452]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[16])/pow(zbar,rrho);
	Mxc_sp_s[40180]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[17]);
	Mxc_sp_s[40372]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[17];
	Mxc_sp_s[40756]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[17]);
	Mxc_sp_s[41524]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[17])/pow(zbar,rrho);
	Mxc_sp_s[43252]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[18]);
	Mxc_sp_s[43444]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[18];
	Mxc_sp_s[43828]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[18]);
	Mxc_sp_s[44596]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[18])/pow(zbar,rrho);
	Mxc_sp_s[46324]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[19]);
	Mxc_sp_s[46516]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[19];
	Mxc_sp_s[46900]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[19]);
	Mxc_sp_s[47668]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[19])/pow(zbar,rrho);
	Mxc_sp_s[49396]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[20]);
	Mxc_sp_s[49588]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[20];
	Mxc_sp_s[49972]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[20]);
	Mxc_sp_s[50740]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[20])/pow(zbar,rrho);
	Mxc_sp_s[52468]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[21]);
	Mxc_sp_s[52660]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[21];
	Mxc_sp_s[53044]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[21]);
	Mxc_sp_s[53812]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[21])/pow(zbar,rrho);
	Mxc_sp_s[55540]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[22]);
	Mxc_sp_s[55732]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[22];
	Mxc_sp_s[56116]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[22]);
	Mxc_sp_s[56884]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[22])/pow(zbar,rrho);
	Mxc_sp_s[58612]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[23]);
	Mxc_sp_s[58804]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[23];
	Mxc_sp_s[59188]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[23]);
	Mxc_sp_s[59956]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[23])/pow(zbar,rrho);
	Mxc_sp_s[3125]=iiota*Pssp*zbar;
	Mxc_sp_s[3701]=iiota*Pssp*zbar;
	Mxc_sp_s[19637]=-Pssp;
	Mxc_sp_s[18678]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxc_sp_s[19830]=-(pow(E,yss[7])*Pssp);
	Mxc_sp_s[20214]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[20406]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[3319]=-((Pssp*zbar)/(1 + yss[5]));
	Mxc_sp_s[3511]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[3703]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxc_sp_s[3895]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxc_sp_s[4279]=-(pow(E,yss[11])*ebar*Pssp);
	Mxc_sp_s[18487]=-(pow(E,yss[0])*Pssp);
	Mxc_sp_s[18679]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxc_sp_s[18871]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxc_sp_s[19063]=-(pow(E,yss[3])*Pssp);
	Mxc_sp_s[19447]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[19831]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxc_sp_s[20215]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[20407]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[3128]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[3704]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[19064]=pow(E,yss[3])*Pssp;
	Mxc_sp_s[20216]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[20408]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[3129]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[3321]=(Pssp*zbar)/(1 + yss[5]);
	Mxc_sp_s[3705]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxc_sp_s[3897]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[18681]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[18873]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[19449]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[19641]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[19833]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[20217]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[20409]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[20218]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[20410]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[3323]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxc_sp_s[4091]=Pssp;
	Mxc_sp_s[19451]=-Pssp;
	Mxc_sp_s[20219]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[20411]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[3132]=pow(E,xss[0])*Pssp;
	Mxc_sp_s[19260]=-(pow(E,xss[0])*Pssp);
	Mxc_sp_s[3517]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[3709]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[3901]=pow(E,yss[2])*pbar*Pssp;
	Mxc_sp_s[18685]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[18877]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxc_sp_s[20221]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[20413]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[20605]=pow(E,yss[11])*Pssp;
	Mxc_sp_s[3326]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[3710]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[20222]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[20414]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[20606]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[20798]=Pssp;
	Mxc_sp_s[3327]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[3711]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[20223]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[20415]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[20607]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[20991]=Pssp;
	Mxc_sp_s[4288]=ebar*Pssp;
	Mxc_sp_s[18496]=pow(E,yss[0] - yss[11])*Pssp;
	Mxc_sp_s[19072]=pow(E,yss[3] - yss[11])*Pssp;
	Mxc_sp_s[20224]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[20416]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[20608]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxc_sp_s[21184]=Pssp;
	Mxc_sp_s[3137]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[3329]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[3521]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[3713]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxc_sp_s[3905]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[4097]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[4289]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[4481]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[20225]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[20417]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[21377]=Pssp;
	Mxc_sp_s[38465]=(Pssp*pow(zbar,rrho)*Hs[16]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[41537]=(Pssp*pow(zbar,rrho)*Hs[17]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[44609]=(Pssp*pow(zbar,rrho)*Hs[18]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[47681]=(Pssp*pow(zbar,rrho)*Hs[19]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[50753]=(Pssp*pow(zbar,rrho)*Hs[20]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[53825]=(Pssp*pow(zbar,rrho)*Hs[21]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[56897]=(Pssp*pow(zbar,rrho)*Hs[22]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[59969]=(Pssp*pow(zbar,rrho)*Hs[23]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[3522]=-Pssp;
	Mxc_sp_s[3715]=-Pssp;
	Mxc_sp_s[3908]=-Pssp;
	Mxc_sp_s[4485]=-Pssp;
	Mxc_sp_s[4294]=-Pssp;
	Mxc_sp_s[4103]=-Pssp;
	Mxc_sp_s[6024]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxc_sp_s[21576]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxc_sp_s[21768]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxc_sp_s[23112]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[23304]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[23496]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[5065]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[5257]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[5449]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[21769]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[21961]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[22537]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxc_sp_s[23113]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxc_sp_s[23305]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[23497]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[5066]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[5258]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[21770]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[21962]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[22538]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxc_sp_s[22922]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[23114]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxc_sp_s[23306]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[23498]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[4683]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[4875]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[5067]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[5259]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxc_sp_s[5451]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[5643]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[5835]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[6027]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[22539]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxc_sp_s[23115]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[23307]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxc_sp_s[23499]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxc_sp_s[38475]=(bbeta*pow(E,yss[8])*Pssp*Hs[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[41547]=(bbeta*pow(E,yss[8])*Pssp*Hs[25]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[44619]=(bbeta*pow(E,yss[8])*Pssp*Hs[26]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[47691]=(bbeta*pow(E,yss[8])*Pssp*Hs[27]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[50763]=(bbeta*pow(E,yss[8])*Pssp*Hs[28]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[53835]=(bbeta*pow(E,yss[8])*Pssp*Hs[29]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[56907]=(bbeta*pow(E,yss[8])*Pssp*Hs[30]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[59979]=(bbeta*pow(E,yss[8])*Pssp*Hs[31]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[4684]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxc_sp_s[4876]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxc_sp_s[5068]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxc_sp_s[5260]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxc_sp_s[5452]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxc_sp_s[5644]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxc_sp_s[5836]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxc_sp_s[6028]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxc_sp_s[22732]=-(kkappa*Pssp*yss[9]);
	Mxc_sp_s[23116]=pow(E,yss[8])*Pssp;
	Mxc_sp_s[23308]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxc_sp_s[23500]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxc_sp_s[37132]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[24]);
	Mxc_sp_s[37324]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[24];
	Mxc_sp_s[37708]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[24]);
	Mxc_sp_s[38476]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[24])/pow(zbar,rrho);
	Mxc_sp_s[40204]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[25]);
	Mxc_sp_s[40396]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[25];
	Mxc_sp_s[40780]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[25]);
	Mxc_sp_s[41548]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[25])/pow(zbar,rrho);
	Mxc_sp_s[43276]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[26]);
	Mxc_sp_s[43468]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[26];
	Mxc_sp_s[43852]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[26]);
	Mxc_sp_s[44620]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[26])/pow(zbar,rrho);
	Mxc_sp_s[46348]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[27]);
	Mxc_sp_s[46540]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[27];
	Mxc_sp_s[46924]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[27]);
	Mxc_sp_s[47692]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[27])/pow(zbar,rrho);
	Mxc_sp_s[49420]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[28]);
	Mxc_sp_s[49612]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[28];
	Mxc_sp_s[49996]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[28]);
	Mxc_sp_s[50764]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[28])/pow(zbar,rrho);
	Mxc_sp_s[52492]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[29]);
	Mxc_sp_s[52684]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[29];
	Mxc_sp_s[53068]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[29]);
	Mxc_sp_s[53836]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[29])/pow(zbar,rrho);
	Mxc_sp_s[55564]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[30]);
	Mxc_sp_s[55756]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[30];
	Mxc_sp_s[56140]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[30]);
	Mxc_sp_s[56908]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[30])/pow(zbar,rrho);
	Mxc_sp_s[58636]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[31]);
	Mxc_sp_s[58828]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[31];
	Mxc_sp_s[59212]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[31]);
	Mxc_sp_s[59980]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[31])/pow(zbar,rrho);
	Mxc_sp_s[4685]=iiota*Pssp*zbar;
	Mxc_sp_s[5261]=iiota*Pssp*zbar;
	Mxc_sp_s[22733]=-Pssp;
	Mxc_sp_s[21774]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxc_sp_s[22926]=-(pow(E,yss[7])*Pssp);
	Mxc_sp_s[23310]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[23502]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[4879]=-((Pssp*zbar)/(1 + yss[5]));
	Mxc_sp_s[5071]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[5263]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxc_sp_s[5455]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxc_sp_s[5839]=-(pow(E,yss[11])*ebar*Pssp);
	Mxc_sp_s[21583]=-(pow(E,yss[0])*Pssp);
	Mxc_sp_s[21775]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxc_sp_s[21967]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxc_sp_s[22159]=-(pow(E,yss[3])*Pssp);
	Mxc_sp_s[22543]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[22927]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxc_sp_s[23311]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[23503]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[4688]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[5264]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[22160]=pow(E,yss[3])*Pssp;
	Mxc_sp_s[23312]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[23504]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[4689]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[4881]=(Pssp*zbar)/(1 + yss[5]);
	Mxc_sp_s[5265]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxc_sp_s[5457]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[21777]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[21969]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[22545]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[22737]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[22929]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[23313]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[23505]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[23314]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[23506]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[4883]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxc_sp_s[5651]=Pssp;
	Mxc_sp_s[22547]=-Pssp;
	Mxc_sp_s[23315]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[23507]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[4692]=pow(E,xss[0])*Pssp;
	Mxc_sp_s[22356]=-(pow(E,xss[0])*Pssp);
	Mxc_sp_s[5077]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[5269]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[5461]=pow(E,yss[2])*pbar*Pssp;
	Mxc_sp_s[21781]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[21973]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxc_sp_s[23317]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[23509]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[23701]=pow(E,yss[11])*Pssp;
	Mxc_sp_s[4886]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[5270]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[23318]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[23510]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[23702]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[23894]=Pssp;
	Mxc_sp_s[4887]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[5271]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[23319]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[23511]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[23703]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[24087]=Pssp;
	Mxc_sp_s[5848]=ebar*Pssp;
	Mxc_sp_s[21592]=pow(E,yss[0] - yss[11])*Pssp;
	Mxc_sp_s[22168]=pow(E,yss[3] - yss[11])*Pssp;
	Mxc_sp_s[23320]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[23512]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[23704]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxc_sp_s[24280]=Pssp;
	Mxc_sp_s[4697]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[4889]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[5081]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[5273]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxc_sp_s[5465]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[5657]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[5849]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[6041]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[23321]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[23513]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[24473]=Pssp;
	Mxc_sp_s[38489]=(Pssp*pow(zbar,rrho)*Hs[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[41561]=(Pssp*pow(zbar,rrho)*Hs[25]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[44633]=(Pssp*pow(zbar,rrho)*Hs[26]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[47705]=(Pssp*pow(zbar,rrho)*Hs[27]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[50777]=(Pssp*pow(zbar,rrho)*Hs[28]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[53849]=(Pssp*pow(zbar,rrho)*Hs[29]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[56921]=(Pssp*pow(zbar,rrho)*Hs[30]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[59993]=(Pssp*pow(zbar,rrho)*Hs[31]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[5082]=-Pssp;
	Mxc_sp_s[5275]=-Pssp;
	Mxc_sp_s[5468]=-Pssp;
	Mxc_sp_s[6045]=-Pssp;
	Mxc_sp_s[5854]=-Pssp;
	Mxc_sp_s[5663]=-Pssp;
	Mxc_sp_s[7584]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxc_sp_s[24672]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxc_sp_s[24864]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxc_sp_s[26208]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[26400]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[26592]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[6625]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[6817]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[7009]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[24865]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[25057]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[25633]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxc_sp_s[26209]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxc_sp_s[26401]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[26593]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[6626]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[6818]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[24866]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[25058]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[25634]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxc_sp_s[26018]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[26210]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxc_sp_s[26402]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[26594]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[6243]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[6435]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[6627]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[6819]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxc_sp_s[7011]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[7203]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[7395]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[7587]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[25635]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxc_sp_s[26211]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[26403]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxc_sp_s[26595]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxc_sp_s[38499]=(bbeta*pow(E,yss[8])*Pssp*Hs[32]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[41571]=(bbeta*pow(E,yss[8])*Pssp*Hs[33]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[44643]=(bbeta*pow(E,yss[8])*Pssp*Hs[34]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[47715]=(bbeta*pow(E,yss[8])*Pssp*Hs[35]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[50787]=(bbeta*pow(E,yss[8])*Pssp*Hs[36]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[53859]=(bbeta*pow(E,yss[8])*Pssp*Hs[37]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[56931]=(bbeta*pow(E,yss[8])*Pssp*Hs[38]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[60003]=(bbeta*pow(E,yss[8])*Pssp*Hs[39]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[6244]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxc_sp_s[6436]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxc_sp_s[6628]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxc_sp_s[6820]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxc_sp_s[7012]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxc_sp_s[7204]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxc_sp_s[7396]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxc_sp_s[7588]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxc_sp_s[25828]=-(kkappa*Pssp*yss[9]);
	Mxc_sp_s[26212]=pow(E,yss[8])*Pssp;
	Mxc_sp_s[26404]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxc_sp_s[26596]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxc_sp_s[37156]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[32]);
	Mxc_sp_s[37348]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[32];
	Mxc_sp_s[37732]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[32]);
	Mxc_sp_s[38500]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[32])/pow(zbar,rrho);
	Mxc_sp_s[40228]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[33]);
	Mxc_sp_s[40420]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[33];
	Mxc_sp_s[40804]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[33]);
	Mxc_sp_s[41572]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[33])/pow(zbar,rrho);
	Mxc_sp_s[43300]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[34]);
	Mxc_sp_s[43492]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[34];
	Mxc_sp_s[43876]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[34]);
	Mxc_sp_s[44644]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[34])/pow(zbar,rrho);
	Mxc_sp_s[46372]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[35]);
	Mxc_sp_s[46564]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[35];
	Mxc_sp_s[46948]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[35]);
	Mxc_sp_s[47716]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[35])/pow(zbar,rrho);
	Mxc_sp_s[49444]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[36]);
	Mxc_sp_s[49636]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[36];
	Mxc_sp_s[50020]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[36]);
	Mxc_sp_s[50788]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[36])/pow(zbar,rrho);
	Mxc_sp_s[52516]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[37]);
	Mxc_sp_s[52708]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[37];
	Mxc_sp_s[53092]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[37]);
	Mxc_sp_s[53860]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[37])/pow(zbar,rrho);
	Mxc_sp_s[55588]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[38]);
	Mxc_sp_s[55780]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[38];
	Mxc_sp_s[56164]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[38]);
	Mxc_sp_s[56932]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[38])/pow(zbar,rrho);
	Mxc_sp_s[58660]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[39]);
	Mxc_sp_s[58852]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[39];
	Mxc_sp_s[59236]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[39]);
	Mxc_sp_s[60004]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[39])/pow(zbar,rrho);
	Mxc_sp_s[6245]=iiota*Pssp*zbar;
	Mxc_sp_s[6821]=iiota*Pssp*zbar;
	Mxc_sp_s[25829]=-Pssp;
	Mxc_sp_s[24870]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxc_sp_s[26022]=-(pow(E,yss[7])*Pssp);
	Mxc_sp_s[26406]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[26598]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[6439]=-((Pssp*zbar)/(1 + yss[5]));
	Mxc_sp_s[6631]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[6823]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxc_sp_s[7015]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxc_sp_s[7399]=-(pow(E,yss[11])*ebar*Pssp);
	Mxc_sp_s[24679]=-(pow(E,yss[0])*Pssp);
	Mxc_sp_s[24871]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxc_sp_s[25063]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxc_sp_s[25255]=-(pow(E,yss[3])*Pssp);
	Mxc_sp_s[25639]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[26023]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxc_sp_s[26407]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[26599]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[6248]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[6824]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[25256]=pow(E,yss[3])*Pssp;
	Mxc_sp_s[26408]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[26600]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[6249]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[6441]=(Pssp*zbar)/(1 + yss[5]);
	Mxc_sp_s[6825]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxc_sp_s[7017]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[24873]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[25065]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[25641]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[25833]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[26025]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[26409]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[26601]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[26410]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[26602]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[6443]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxc_sp_s[7211]=Pssp;
	Mxc_sp_s[25643]=-Pssp;
	Mxc_sp_s[26411]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[26603]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[6252]=pow(E,xss[0])*Pssp;
	Mxc_sp_s[25452]=-(pow(E,xss[0])*Pssp);
	Mxc_sp_s[6637]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[6829]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[7021]=pow(E,yss[2])*pbar*Pssp;
	Mxc_sp_s[24877]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[25069]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxc_sp_s[26413]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[26605]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[26797]=pow(E,yss[11])*Pssp;
	Mxc_sp_s[6446]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[6830]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[26414]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[26606]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[26798]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[26990]=Pssp;
	Mxc_sp_s[6447]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[6831]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[26415]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[26607]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[26799]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[27183]=Pssp;
	Mxc_sp_s[7408]=ebar*Pssp;
	Mxc_sp_s[24688]=pow(E,yss[0] - yss[11])*Pssp;
	Mxc_sp_s[25264]=pow(E,yss[3] - yss[11])*Pssp;
	Mxc_sp_s[26416]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[26608]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[26800]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxc_sp_s[27376]=Pssp;
	Mxc_sp_s[6257]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[6449]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[6641]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[6833]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxc_sp_s[7025]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[7217]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[7409]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[7601]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[26417]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[26609]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[27569]=Pssp;
	Mxc_sp_s[38513]=(Pssp*pow(zbar,rrho)*Hs[32]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[41585]=(Pssp*pow(zbar,rrho)*Hs[33]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[44657]=(Pssp*pow(zbar,rrho)*Hs[34]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[47729]=(Pssp*pow(zbar,rrho)*Hs[35]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[50801]=(Pssp*pow(zbar,rrho)*Hs[36]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[53873]=(Pssp*pow(zbar,rrho)*Hs[37]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[56945]=(Pssp*pow(zbar,rrho)*Hs[38]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[60017]=(Pssp*pow(zbar,rrho)*Hs[39]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[6642]=-Pssp;
	Mxc_sp_s[6835]=-Pssp;
	Mxc_sp_s[7028]=-Pssp;
	Mxc_sp_s[7605]=-Pssp;
	Mxc_sp_s[7414]=-Pssp;
	Mxc_sp_s[7223]=-Pssp;
	Mxc_sp_s[9144]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxc_sp_s[27768]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxc_sp_s[27960]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxc_sp_s[29304]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[29496]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[29688]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[8185]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[8377]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[8569]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[27961]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[28153]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[28729]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxc_sp_s[29305]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxc_sp_s[29497]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[29689]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[8186]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[8378]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[27962]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[28154]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[28730]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxc_sp_s[29114]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[29306]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxc_sp_s[29498]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[29690]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[7803]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[7995]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[8187]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[8379]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxc_sp_s[8571]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[8763]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[8955]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[9147]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[28731]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxc_sp_s[29307]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[29499]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxc_sp_s[29691]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxc_sp_s[38523]=(bbeta*pow(E,yss[8])*Pssp*Hs[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[41595]=(bbeta*pow(E,yss[8])*Pssp*Hs[41]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[44667]=(bbeta*pow(E,yss[8])*Pssp*Hs[42]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[47739]=(bbeta*pow(E,yss[8])*Pssp*Hs[43]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[50811]=(bbeta*pow(E,yss[8])*Pssp*Hs[44]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[53883]=(bbeta*pow(E,yss[8])*Pssp*Hs[45]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[56955]=(bbeta*pow(E,yss[8])*Pssp*Hs[46]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[60027]=(bbeta*pow(E,yss[8])*Pssp*Hs[47]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[7804]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxc_sp_s[7996]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxc_sp_s[8188]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxc_sp_s[8380]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxc_sp_s[8572]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxc_sp_s[8764]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxc_sp_s[8956]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxc_sp_s[9148]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxc_sp_s[28924]=-(kkappa*Pssp*yss[9]);
	Mxc_sp_s[29308]=pow(E,yss[8])*Pssp;
	Mxc_sp_s[29500]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxc_sp_s[29692]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxc_sp_s[37180]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[40]);
	Mxc_sp_s[37372]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[40];
	Mxc_sp_s[37756]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[40]);
	Mxc_sp_s[38524]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[40])/pow(zbar,rrho);
	Mxc_sp_s[40252]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[41]);
	Mxc_sp_s[40444]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[41];
	Mxc_sp_s[40828]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[41]);
	Mxc_sp_s[41596]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[41])/pow(zbar,rrho);
	Mxc_sp_s[43324]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[42]);
	Mxc_sp_s[43516]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[42];
	Mxc_sp_s[43900]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[42]);
	Mxc_sp_s[44668]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[42])/pow(zbar,rrho);
	Mxc_sp_s[46396]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[43]);
	Mxc_sp_s[46588]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[43];
	Mxc_sp_s[46972]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[43]);
	Mxc_sp_s[47740]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[43])/pow(zbar,rrho);
	Mxc_sp_s[49468]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[44]);
	Mxc_sp_s[49660]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[44];
	Mxc_sp_s[50044]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[44]);
	Mxc_sp_s[50812]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[44])/pow(zbar,rrho);
	Mxc_sp_s[52540]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[45]);
	Mxc_sp_s[52732]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[45];
	Mxc_sp_s[53116]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[45]);
	Mxc_sp_s[53884]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[45])/pow(zbar,rrho);
	Mxc_sp_s[55612]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[46]);
	Mxc_sp_s[55804]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[46];
	Mxc_sp_s[56188]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[46]);
	Mxc_sp_s[56956]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[46])/pow(zbar,rrho);
	Mxc_sp_s[58684]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[47]);
	Mxc_sp_s[58876]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[47];
	Mxc_sp_s[59260]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[47]);
	Mxc_sp_s[60028]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[47])/pow(zbar,rrho);
	Mxc_sp_s[7805]=iiota*Pssp*zbar;
	Mxc_sp_s[8381]=iiota*Pssp*zbar;
	Mxc_sp_s[28925]=-Pssp;
	Mxc_sp_s[27966]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxc_sp_s[29118]=-(pow(E,yss[7])*Pssp);
	Mxc_sp_s[29502]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[29694]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[7999]=-((Pssp*zbar)/(1 + yss[5]));
	Mxc_sp_s[8191]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[8383]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxc_sp_s[8575]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxc_sp_s[8959]=-(pow(E,yss[11])*ebar*Pssp);
	Mxc_sp_s[27775]=-(pow(E,yss[0])*Pssp);
	Mxc_sp_s[27967]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxc_sp_s[28159]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxc_sp_s[28351]=-(pow(E,yss[3])*Pssp);
	Mxc_sp_s[28735]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[29119]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxc_sp_s[29503]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[29695]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[7808]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[8384]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[28352]=pow(E,yss[3])*Pssp;
	Mxc_sp_s[29504]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[29696]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[7809]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[8001]=(Pssp*zbar)/(1 + yss[5]);
	Mxc_sp_s[8385]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxc_sp_s[8577]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[27969]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[28161]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[28737]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[28929]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[29121]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[29505]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[29697]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[29506]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[29698]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[8003]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxc_sp_s[8771]=Pssp;
	Mxc_sp_s[28739]=-Pssp;
	Mxc_sp_s[29507]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[29699]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[7812]=pow(E,xss[0])*Pssp;
	Mxc_sp_s[28548]=-(pow(E,xss[0])*Pssp);
	Mxc_sp_s[8197]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[8389]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[8581]=pow(E,yss[2])*pbar*Pssp;
	Mxc_sp_s[27973]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[28165]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxc_sp_s[29509]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[29701]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[29893]=pow(E,yss[11])*Pssp;
	Mxc_sp_s[8006]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[8390]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[29510]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[29702]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[29894]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[30086]=Pssp;
	Mxc_sp_s[8007]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[8391]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[29511]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[29703]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[29895]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[30279]=Pssp;
	Mxc_sp_s[8968]=ebar*Pssp;
	Mxc_sp_s[27784]=pow(E,yss[0] - yss[11])*Pssp;
	Mxc_sp_s[28360]=pow(E,yss[3] - yss[11])*Pssp;
	Mxc_sp_s[29512]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[29704]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[29896]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxc_sp_s[30472]=Pssp;
	Mxc_sp_s[7817]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[8009]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[8201]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[8393]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxc_sp_s[8585]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[8777]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[8969]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[9161]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[29513]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[29705]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[30665]=Pssp;
	Mxc_sp_s[38537]=(Pssp*pow(zbar,rrho)*Hs[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[41609]=(Pssp*pow(zbar,rrho)*Hs[41]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[44681]=(Pssp*pow(zbar,rrho)*Hs[42]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[47753]=(Pssp*pow(zbar,rrho)*Hs[43]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[50825]=(Pssp*pow(zbar,rrho)*Hs[44]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[53897]=(Pssp*pow(zbar,rrho)*Hs[45]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[56969]=(Pssp*pow(zbar,rrho)*Hs[46]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[60041]=(Pssp*pow(zbar,rrho)*Hs[47]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[8202]=-Pssp;
	Mxc_sp_s[8395]=-Pssp;
	Mxc_sp_s[8588]=-Pssp;
	Mxc_sp_s[9165]=-Pssp;
	Mxc_sp_s[8974]=-Pssp;
	Mxc_sp_s[8783]=-Pssp;
	Mxc_sp_s[10704]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxc_sp_s[30864]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxc_sp_s[31056]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxc_sp_s[32400]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[32592]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[32784]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[9745]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[9937]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[10129]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[31057]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[31249]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[31825]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxc_sp_s[32401]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxc_sp_s[32593]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[32785]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[9746]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[9938]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[31058]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[31250]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[31826]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxc_sp_s[32210]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[32402]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxc_sp_s[32594]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[32786]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[9363]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[9555]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[9747]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[9939]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxc_sp_s[10131]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[10323]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[10515]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[10707]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[31827]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxc_sp_s[32403]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[32595]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxc_sp_s[32787]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxc_sp_s[38547]=(bbeta*pow(E,yss[8])*Pssp*Hs[48]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[41619]=(bbeta*pow(E,yss[8])*Pssp*Hs[49]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[44691]=(bbeta*pow(E,yss[8])*Pssp*Hs[50]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[47763]=(bbeta*pow(E,yss[8])*Pssp*Hs[51]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[50835]=(bbeta*pow(E,yss[8])*Pssp*Hs[52]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[53907]=(bbeta*pow(E,yss[8])*Pssp*Hs[53]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[56979]=(bbeta*pow(E,yss[8])*Pssp*Hs[54]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[60051]=(bbeta*pow(E,yss[8])*Pssp*Hs[55]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[9364]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxc_sp_s[9556]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxc_sp_s[9748]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxc_sp_s[9940]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxc_sp_s[10132]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxc_sp_s[10324]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxc_sp_s[10516]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxc_sp_s[10708]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxc_sp_s[32020]=-(kkappa*Pssp*yss[9]);
	Mxc_sp_s[32404]=pow(E,yss[8])*Pssp;
	Mxc_sp_s[32596]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxc_sp_s[32788]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxc_sp_s[37204]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[48]);
	Mxc_sp_s[37396]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[48];
	Mxc_sp_s[37780]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[48]);
	Mxc_sp_s[38548]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[48])/pow(zbar,rrho);
	Mxc_sp_s[40276]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[49]);
	Mxc_sp_s[40468]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[49];
	Mxc_sp_s[40852]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[49]);
	Mxc_sp_s[41620]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[49])/pow(zbar,rrho);
	Mxc_sp_s[43348]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[50]);
	Mxc_sp_s[43540]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[50];
	Mxc_sp_s[43924]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[50]);
	Mxc_sp_s[44692]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[50])/pow(zbar,rrho);
	Mxc_sp_s[46420]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[51]);
	Mxc_sp_s[46612]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[51];
	Mxc_sp_s[46996]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[51]);
	Mxc_sp_s[47764]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[51])/pow(zbar,rrho);
	Mxc_sp_s[49492]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[52]);
	Mxc_sp_s[49684]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[52];
	Mxc_sp_s[50068]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[52]);
	Mxc_sp_s[50836]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[52])/pow(zbar,rrho);
	Mxc_sp_s[52564]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[53]);
	Mxc_sp_s[52756]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[53];
	Mxc_sp_s[53140]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[53]);
	Mxc_sp_s[53908]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[53])/pow(zbar,rrho);
	Mxc_sp_s[55636]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[54]);
	Mxc_sp_s[55828]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[54];
	Mxc_sp_s[56212]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[54]);
	Mxc_sp_s[56980]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[54])/pow(zbar,rrho);
	Mxc_sp_s[58708]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[55]);
	Mxc_sp_s[58900]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[55];
	Mxc_sp_s[59284]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[55]);
	Mxc_sp_s[60052]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[55])/pow(zbar,rrho);
	Mxc_sp_s[9365]=iiota*Pssp*zbar;
	Mxc_sp_s[9941]=iiota*Pssp*zbar;
	Mxc_sp_s[32021]=-Pssp;
	Mxc_sp_s[31062]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxc_sp_s[32214]=-(pow(E,yss[7])*Pssp);
	Mxc_sp_s[32598]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[32790]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[9559]=-((Pssp*zbar)/(1 + yss[5]));
	Mxc_sp_s[9751]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[9943]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxc_sp_s[10135]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxc_sp_s[10519]=-(pow(E,yss[11])*ebar*Pssp);
	Mxc_sp_s[30871]=-(pow(E,yss[0])*Pssp);
	Mxc_sp_s[31063]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxc_sp_s[31255]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxc_sp_s[31447]=-(pow(E,yss[3])*Pssp);
	Mxc_sp_s[31831]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[32215]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxc_sp_s[32599]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[32791]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[9368]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[9944]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[31448]=pow(E,yss[3])*Pssp;
	Mxc_sp_s[32600]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[32792]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[9369]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[9561]=(Pssp*zbar)/(1 + yss[5]);
	Mxc_sp_s[9945]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxc_sp_s[10137]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[31065]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[31257]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[31833]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[32025]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[32217]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[32601]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[32793]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[32602]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[32794]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[9563]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxc_sp_s[10331]=Pssp;
	Mxc_sp_s[31835]=-Pssp;
	Mxc_sp_s[32603]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[32795]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[9372]=pow(E,xss[0])*Pssp;
	Mxc_sp_s[31644]=-(pow(E,xss[0])*Pssp);
	Mxc_sp_s[9757]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[9949]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[10141]=pow(E,yss[2])*pbar*Pssp;
	Mxc_sp_s[31069]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[31261]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxc_sp_s[32605]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[32797]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[32989]=pow(E,yss[11])*Pssp;
	Mxc_sp_s[9566]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[9950]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[32606]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[32798]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[32990]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[33182]=Pssp;
	Mxc_sp_s[9567]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[9951]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[32607]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[32799]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[32991]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[33375]=Pssp;
	Mxc_sp_s[10528]=ebar*Pssp;
	Mxc_sp_s[30880]=pow(E,yss[0] - yss[11])*Pssp;
	Mxc_sp_s[31456]=pow(E,yss[3] - yss[11])*Pssp;
	Mxc_sp_s[32608]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[32800]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[32992]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxc_sp_s[33568]=Pssp;
	Mxc_sp_s[9377]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[9569]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[9761]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[9953]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxc_sp_s[10145]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[10337]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[10529]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[10721]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[32609]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[32801]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[33761]=Pssp;
	Mxc_sp_s[38561]=(Pssp*pow(zbar,rrho)*Hs[48]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[41633]=(Pssp*pow(zbar,rrho)*Hs[49]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[44705]=(Pssp*pow(zbar,rrho)*Hs[50]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[47777]=(Pssp*pow(zbar,rrho)*Hs[51]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[50849]=(Pssp*pow(zbar,rrho)*Hs[52]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[53921]=(Pssp*pow(zbar,rrho)*Hs[53]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[56993]=(Pssp*pow(zbar,rrho)*Hs[54]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[60065]=(Pssp*pow(zbar,rrho)*Hs[55]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[9762]=-Pssp;
	Mxc_sp_s[9955]=-Pssp;
	Mxc_sp_s[10148]=-Pssp;
	Mxc_sp_s[10725]=-Pssp;
	Mxc_sp_s[10534]=-Pssp;
	Mxc_sp_s[10343]=-Pssp;
	Mxc_sp_s[12264]=Pssp/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho);
	Mxc_sp_s[33960]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho);
	Mxc_sp_s[34152]=pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho;
	Mxc_sp_s[35496]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[35688]=dP2ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[35880]=dP1ssp*(-pow(E,yss[8]) + pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-rrho));
	Mxc_sp_s[11305]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[11497]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[11689]=-(pbar*Pssp*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[34153]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[34345]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[34921]=-((pbar*pphi*Pssp*(pow(E,yss[8]) + yss[9]))/pow(E,yss[8]));
	Mxc_sp_s[35497]=(pbar*pphi*Pssp*(1 + yss[5])*yss[9])/pow(E,yss[8]);
	Mxc_sp_s[35689]=-((pbar*pphi*Pssp*(1 + yss[5]))/pow(E,yss[8])) + dP2ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[35881]=dP1ssp*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - pbar*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[11306]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[11498]=pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[34154]=-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[34346]=aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[34922]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(pow(E,yss[8]) + yss[9]));
	Mxc_sp_s[35306]=-(pow(E,yss[7])*pphi*Pssp*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[35498]=pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])*yss[9];
	Mxc_sp_s[35690]=-(pow(E,yss[7] - yss[8])*pphi*Pssp*(1 + yss[5])) + dP2ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[35882]=dP1ssp*(-pow(pow(E,yss[1]),-1 + oomega) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[7])*pphi*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])));
	Mxc_sp_s[10923]=(bbeta*pow(E,yss[8])*Pssp*Gsp[8]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[11115]=(bbeta*pow(E,yss[8])*Pssp*Gsp[24]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[11307]=(bbeta*pow(E,yss[8])*Pssp*Gsp[40]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[11499]=-((bbeta*pow(E,yss[8])*Pssp*(rrho*rrhoz - Gsp[56])*(1 + yss[5]))/pow(zbar,rrho));
	Mxc_sp_s[11691]=(bbeta*pow(E,yss[8])*Pssp*Gsp[72]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[11883]=(bbeta*pow(E,yss[8])*Pssp*Gsp[88]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[12075]=(bbeta*pow(E,yss[8])*Pssp*Gsp[104]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[12267]=(bbeta*pow(E,yss[8])*Pssp*Gsp[120]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[34923]=(bbeta*pow(E,yss[8])*Pssp)/pow(zbar,rrho);
	Mxc_sp_s[35499]=-(pow(E,yss[8])*Pssp);
	Mxc_sp_s[35691]=Pssp + (bbeta*dP2ssp*pow(E,yss[8])*(1 + yss[5]))/pow(zbar,rrho) - dP2ssp*(pow(E,yss[8]) - yss[9]);
	Mxc_sp_s[35883]=-((dP1ssp*(-(bbeta*pow(E,yss[8])*(1 + yss[5])) + pow(zbar,rrho)*(pow(E,yss[8]) - yss[9])))/pow(zbar,rrho));
	Mxc_sp_s[38571]=(bbeta*pow(E,yss[8])*Pssp*Hs[56]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[41643]=(bbeta*pow(E,yss[8])*Pssp*Hs[57]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[44715]=(bbeta*pow(E,yss[8])*Pssp*Hs[58]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[47787]=(bbeta*pow(E,yss[8])*Pssp*Hs[59]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[50859]=(bbeta*pow(E,yss[8])*Pssp*Hs[60]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[53931]=(bbeta*pow(E,yss[8])*Pssp*Hs[61]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[57003]=(bbeta*pow(E,yss[8])*Pssp*Hs[62]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[60075]=(bbeta*pow(E,yss[8])*Pssp*Hs[63]*(1 + yss[5]))/pow(zbar,rrho);
	Mxc_sp_s[10924]=(pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2) + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha) + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[1] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[2] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[2] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[4] - bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[8] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[8]))/pow(zbar,rrho);
	Mxc_sp_s[11116]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[17] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[18] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[20] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[24] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[24]))/pow(zbar,rrho));
	Mxc_sp_s[11308]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoa*pow(zbar,aalpha) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[33] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[34] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[36] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[40] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[40]))/pow(zbar,rrho));
	Mxc_sp_s[11500]=-((pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(-(bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz) + bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*rrho*rrhoz + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*rrhoz*pow(zbar,2) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrhoz*pow(zbar,aalpha) - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*rrho*rrhoz*pow(zbar,aalpha) - pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,1 + rrho) + aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[49] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - aalpha*abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[50] - abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[50] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[52] + bbeta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] - bbeta*ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[56] + abar*bbeta*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[56]))/pow(zbar,rrho));
	Mxc_sp_s[11692]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[65] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[66] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[66] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[68] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[72] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[72]))/pow(zbar,rrho));
	Mxc_sp_s[11884]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[81] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[82] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[82] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[84] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[88] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[88]))/pow(zbar,rrho));
	Mxc_sp_s[12076]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[97] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[98] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[98] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[100] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[104] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[104]))/pow(zbar,rrho));
	Mxc_sp_s[12268]=-((bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*(aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[113] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(eeta,2)*pow(zbar,aalpha)*Gsp[114] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*iiota*pow(zbar,2)*Gsp[116] + pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] - ddelta*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta)*Gsp[120] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha)*Gsp[120]))/pow(zbar,rrho));
	Mxc_sp_s[35116]=-(kkappa*Pssp*yss[9]);
	Mxc_sp_s[35500]=pow(E,yss[8])*Pssp;
	Mxc_sp_s[35692]=-(kkappa*Pssp) + dP2ssp*(pow(E,yss[8]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho) + (bbeta*(-1 + ddelta)*pow(E,yss[8]))/pow(zbar,rrho) - kkappa*yss[9]);
	Mxc_sp_s[35884]=dP1ssp*(-(abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha - rrho)) + pow(E,yss[8])*(1 + (bbeta*(-1 + ddelta))/pow(zbar,rrho)) - kkappa*yss[9]);
	Mxc_sp_s[37228]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[56]);
	Mxc_sp_s[37420]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[56];
	Mxc_sp_s[37804]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[56]);
	Mxc_sp_s[38572]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[56])/pow(zbar,rrho);
	Mxc_sp_s[40300]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[57]);
	Mxc_sp_s[40492]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[57];
	Mxc_sp_s[40876]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[57]);
	Mxc_sp_s[41644]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[57])/pow(zbar,rrho);
	Mxc_sp_s[43372]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[58]);
	Mxc_sp_s[43564]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[58];
	Mxc_sp_s[43948]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[58]);
	Mxc_sp_s[44716]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[58])/pow(zbar,rrho);
	Mxc_sp_s[46444]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[59]);
	Mxc_sp_s[46636]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[59];
	Mxc_sp_s[47020]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[59]);
	Mxc_sp_s[47788]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[59])/pow(zbar,rrho);
	Mxc_sp_s[49516]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[60]);
	Mxc_sp_s[49708]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[60];
	Mxc_sp_s[50092]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[60]);
	Mxc_sp_s[50860]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[60])/pow(zbar,rrho);
	Mxc_sp_s[52588]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[61]);
	Mxc_sp_s[52780]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[61];
	Mxc_sp_s[53164]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[61]);
	Mxc_sp_s[53932]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[61])/pow(zbar,rrho);
	Mxc_sp_s[55660]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[62]);
	Mxc_sp_s[55852]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[62];
	Mxc_sp_s[56236]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[62]);
	Mxc_sp_s[57004]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[62])/pow(zbar,rrho);
	Mxc_sp_s[58732]=-(aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[63]);
	Mxc_sp_s[58924]=abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[63];
	Mxc_sp_s[59308]=-(bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[63]);
	Mxc_sp_s[60076]=(bbeta*pow(E,-xss[0] + yss[8])*pow(pow(E,yss[2]),-aalpha - eeta)*Pssp*((-1 + ddelta)*pow(E,xss[0])*pow(pow(E,yss[2]),aalpha + eeta) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*eeta*pow(zbar,aalpha))*Hs[63])/pow(zbar,rrho);
	Mxc_sp_s[10925]=iiota*Pssp*zbar;
	Mxc_sp_s[11501]=iiota*Pssp*zbar;
	Mxc_sp_s[35117]=-Pssp;
	Mxc_sp_s[34158]=pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Pssp;
	Mxc_sp_s[35310]=-(pow(E,yss[7])*Pssp);
	Mxc_sp_s[35694]=dP2ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[35886]=dP1ssp*(-pow(E,yss[7]) + pow(pow(E,yss[1]),-1 + oomega));
	Mxc_sp_s[11119]=-((Pssp*zbar)/(1 + yss[5]));
	Mxc_sp_s[11311]=abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha);
	Mxc_sp_s[11503]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - (zbar*xss[1])/(1 + yss[5]));
	Mxc_sp_s[11695]=-(pow(E,yss[2])*pbar*Pssp*(1 + pphi*yss[5]));
	Mxc_sp_s[12079]=-(pow(E,yss[11])*ebar*Pssp);
	Mxc_sp_s[33967]=-(pow(E,yss[0])*Pssp);
	Mxc_sp_s[34159]=Pssp*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha) - pow(E,yss[1] + yss[7])*pphi*yss[5]);
	Mxc_sp_s[34351]=pow(E,yss[2])*Pssp*(-pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha) - pbar*pphi*yss[5]);
	Mxc_sp_s[34543]=-(pow(E,yss[3])*Pssp);
	Mxc_sp_s[34927]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) + (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[35311]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*yss[5]);
	Mxc_sp_s[35695]=dP2ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[35887]=dP1ssp*(-pow(E,yss[0]) - pow(E,yss[3]) - pow(E,yss[11])*ebar + xss[1] - pow(E,yss[1] + yss[7])*pphi*yss[5] - (zbar*xss[1])/(1 + yss[5]) + pow(E,yss[2])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha) - pbar*(1 + pphi*yss[5])));
	Mxc_sp_s[10928]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[11504]=-(pow(E,xss[0])*Pssp*zbar);
	Mxc_sp_s[34544]=pow(E,yss[3])*Pssp;
	Mxc_sp_s[35696]=dP2ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[35888]=dP1ssp*(pow(E,yss[3]) - pow(E,xss[0])*(-1 + ddelta + zbar));
	Mxc_sp_s[10929]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[11121]=(Pssp*zbar)/(1 + yss[5]);
	Mxc_sp_s[11505]=(Pssp*zbar*(xss[1] + pow(E,xss[0])*kkappa*(1 + yss[5])))/(1 + yss[5]);
	Mxc_sp_s[11697]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[34161]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[34353]=-(pow(E,yss[2])*pbar*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[34929]=Pssp*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi) - (zbar*xss[1])/pow(1 + yss[5],2));
	Mxc_sp_s[35121]=pow(E,xss[0])*kkappa*Pssp*zbar;
	Mxc_sp_s[35313]=-(pow(E,yss[1] + yss[7])*pphi*Pssp*(1 + yss[5]));
	Mxc_sp_s[35697]=dP2ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[35889]=-Pssp + dP1ssp*(pow(E,xss[0])*kkappa*zbar + (zbar*xss[1])/(1 + yss[5]) - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*(1 + yss[5]) - yss[10]);
	Mxc_sp_s[35698]=(-1 + nnus)*Pssp + dP2ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[35890]=nnus*Pssp + dP1ssp*((-1 + varphibar)*yss[9] + varphibar*yss[10]);
	Mxc_sp_s[11123]=-(pow(E,bbar - xss[1])*ppsir*Pssp);
	Mxc_sp_s[11891]=Pssp;
	Mxc_sp_s[34931]=-Pssp;
	Mxc_sp_s[35699]=dP2ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[35891]=dP1ssp*((-1 + pow(E,bbar - xss[1]))*ppsir + rbar - yss[5]);
	Mxc_sp_s[10932]=pow(E,xss[0])*Pssp;
	Mxc_sp_s[34740]=-(pow(E,xss[0])*Pssp);
	Mxc_sp_s[11317]=-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[11509]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[11701]=pow(E,yss[2])*pbar*Pssp;
	Mxc_sp_s[34165]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha));
	Mxc_sp_s[34357]=pow(E,yss[2])*Pssp*(pbar + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha));
	Mxc_sp_s[35701]=dP2ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[35893]=dP1ssp*(pow(E,yss[11]) + pow(E,yss[2])*(pbar - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(zbar,aalpha)));
	Mxc_sp_s[36085]=pow(E,yss[11])*Pssp;
	Mxc_sp_s[11126]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[11510]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[35702]=dP2ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[35894]=dP1ssp*(-((zbar*xss[1])/pow(E,yss[11])) + yss[12]);
	Mxc_sp_s[36086]=(Pssp*zbar*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[36278]=Pssp;
	Mxc_sp_s[11127]=-((Pssp*zbar)/pow(E,yss[11]));
	Mxc_sp_s[11511]=-((Pssp*zbar*xss[1])/pow(E,yss[11]));
	Mxc_sp_s[35703]=(dP2ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[35895]=(dP1ssp*(xss[1] - zbar*xss[1] + pow(E,yss[11])*yss[13]))/pow(E,yss[11]);
	Mxc_sp_s[36087]=(Pssp*(-1 + zbar)*xss[1])/pow(E,yss[11]);
	Mxc_sp_s[36471]=Pssp;
	Mxc_sp_s[12088]=ebar*Pssp;
	Mxc_sp_s[33976]=pow(E,yss[0] - yss[11])*Pssp;
	Mxc_sp_s[34552]=pow(E,yss[3] - yss[11])*Pssp;
	Mxc_sp_s[35704]=(dP2ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[35896]=(dP1ssp*(pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar + yss[14])))/pow(E,yss[11]);
	Mxc_sp_s[36088]=-(((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*ebar)*Pssp)/pow(E,yss[11]));
	Mxc_sp_s[36664]=Pssp;
	Mxc_sp_s[10937]=(Pssp*pow(zbar,rrho)*Gsp[8]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[11129]=(Pssp*pow(zbar,rrho)*Gsp[24]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[11321]=(Pssp*pow(zbar,rrho)*Gsp[40]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[11513]=-((Pssp*pow(zbar,rrho)*(rrho*rrhoz - Gsp[56])*yss[9])/(bbeta*pow(E,yss[8])));
	Mxc_sp_s[11705]=(Pssp*pow(zbar,rrho)*Gsp[72]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[11897]=(Pssp*pow(zbar,rrho)*Gsp[88]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[12089]=(Pssp*pow(zbar,rrho)*Gsp[104]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[12281]=(Pssp*pow(zbar,rrho)*Gsp[120]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[35705]=(-(Pssp*pow(zbar,rrho)) + dP2ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[35897]=(dP1ssp*(-(pow(zbar,rrho)*yss[9]) + bbeta*pow(E,yss[8])*yss[15]))/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[36857]=Pssp;
	Mxc_sp_s[38585]=(Pssp*pow(zbar,rrho)*Hs[56]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[41657]=(Pssp*pow(zbar,rrho)*Hs[57]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[44729]=(Pssp*pow(zbar,rrho)*Hs[58]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[47801]=(Pssp*pow(zbar,rrho)*Hs[59]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[50873]=(Pssp*pow(zbar,rrho)*Hs[60]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[53945]=(Pssp*pow(zbar,rrho)*Hs[61]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[57017]=(Pssp*pow(zbar,rrho)*Hs[62]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[60089]=(Pssp*pow(zbar,rrho)*Hs[63]*yss[9])/(bbeta*pow(E,yss[8]));
	Mxc_sp_s[11322]=-Pssp;
	Mxc_sp_s[11515]=-Pssp;
	Mxc_sp_s[11708]=-Pssp;
	Mxc_sp_s[12285]=-Pssp;
	Mxc_sp_s[12094]=-Pssp;
	Mxc_sp_s[11903]=-Pssp;
	Nxc_sp_s[0]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[0]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[1]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[8]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[7] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])) - pow(E,yss[8])*Gs[8] + Hs[7]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[0] - pow(pow(E,yss[1]),oomega)*Gs[1])*Hs[119] + (Pssp*Hs[7]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxc_sp_s[1]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[225] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[226] - (pbar*pphi*Pssp*Gs[9]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[5]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[2] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[3] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[115] + (pbar*pphi*Pssp*Gs[9]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[8]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[5]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[8]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[4]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[4]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[3] - pbar*Hs[4]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nxc_sp_s[2]=(-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[225] - pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[225] + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[226] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[2] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[3] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[3] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[114] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[115] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[9]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[5]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[8]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[7]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[7]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[7])*pphi*Gs[7]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[5]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[9] - Gs[8]*yss[9]))) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nxc_sp_s[3]=-(pow(E,yss[8])*Pssp*Gs[8]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[3])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[5]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[5]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[8]*Hs[0]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[1]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[2]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[3]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[4]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[5]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[6]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[7]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[0]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[264]*Hs[1]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[2]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[3]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[4]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[5]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[6]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[7]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[0]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[1]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[520]*Hs[2]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[3]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[4]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[5]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[6]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[7]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[0]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[1]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[2]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[3]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[776]*Hs[3]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[4]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[5]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[6]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[7]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[0]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[1]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[2]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[3]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1032]*Hs[4]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[5]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[6]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[7]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[0]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[1]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[2]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[3]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[4]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1288]*Hs[5]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[6]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[7]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[0]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[1]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[2]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[3]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[4]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[5]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1544]*Hs[6]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[7]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[0]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[1]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[2]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[3]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[4]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[5]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[6]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1800]*Hs[7]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[3]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[5])/pow(zbar,rrho) - pow(E,yss[8])*Gs[8] + Gs[9] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[3]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nxc_sp_s[4]=-(kkappa*Pssp*Gs[9]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[8]*Gs[232] - kkappa*Pssp*Gs[6]*Gs[233] + pow(E,yss[8])*iiota*Pssp*zbar*Gs[232]*(-1 + Hs[0] + Hs[3]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1]*Hs[0]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[2]*Hs[0]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[4]*Hs[0]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[8]*Hs[0]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[1]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[1]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[1]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[1]*Hs[112])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[2]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[2]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[2]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[2]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[3]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[3]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[3]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[3]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[4]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[4]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[4]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[4]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[5]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[5]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[5]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[5]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[6]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[6]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[6]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[6]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[7]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[7]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[7]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[7]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[0]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[0]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[0]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[0]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[257]*Hs[1]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[258]*Hs[1]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[260]*Hs[1]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[264]*Hs[1]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[2]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[2]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[2]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[2]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[3]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[3]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[3]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[3]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[4]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[4]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[4]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[4]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[5]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[5]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[5]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[5]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[6]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[6]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[6]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[6]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[7]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[7]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[7]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[7]*Hs[113])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[0]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[0]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[0]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[0]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[0]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[1]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[1]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[1]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[1]*Hs[114])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[2]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[513]*Hs[2]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[514]*Hs[2]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[516]*Hs[2]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[520]*Hs[2]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[3]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[3]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[3]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[3]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[4]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[4]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[4]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[4]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[5]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[5]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[5]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[5]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[6]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[6]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[6]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[6]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[7]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[7]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[7]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[7]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[0]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[0]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[0]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[0]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[0]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[1]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[1]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[1]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[1]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[2]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[2]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[2]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[2]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[2]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[3]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[769]*Hs[3]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[770]*Hs[3]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[772]*Hs[3]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[776]*Hs[3]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[4]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[4]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[4]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[4]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[5]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[5]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[5]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[5]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[6]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[6]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[6]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[6]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[7]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[7]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[7]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[7]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*Hs[115])/pow(zbar,rrho) - pow(E,yss[8])*iiota*Pssp*zbar*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[8]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[0]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[0]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[0]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[0]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[1]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[1]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[1]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[1]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[2]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[2]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[2]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[2]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[3]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[3]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[3]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[3]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1025]*Hs[4]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1026]*Hs[4]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1028]*Hs[4]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1032]*Hs[4]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[5]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[5]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[5]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[5]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[6]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[6]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[6]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[6]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[7]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[7]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[7]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[7]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[0]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[0]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[0]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[0]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[1]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[1]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[1]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[1]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[2]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[2]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[2]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[2]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[3]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[3]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[3]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[3]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[4]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[4]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[4]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[4]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1281]*Hs[5]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1282]*Hs[5]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1284]*Hs[5]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1288]*Hs[5]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[6]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[6]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[6]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[6]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[7]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[7]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[7]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[7]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[0]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[0]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[0]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[0]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[1]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[1]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[1]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[1]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[2]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[2]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[2]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[2]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[3]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[3]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[3]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[3]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[4]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[4]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[4]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[4]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[5]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[5]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[5]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[5]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1537]*Hs[6]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1538]*Hs[6]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1540]*Hs[6]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1544]*Hs[6]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[7]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[7]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[7]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[7]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[0]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[0]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[0]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[0]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[1]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[1]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[1]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[1]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[2]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[2]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[2]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[2]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[3]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[3]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[3]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[3]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[4]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[4]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[4]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[4]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[5]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[5]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[5]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[5]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[6]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[6]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[6]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[6]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1793]*Hs[7]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1794]*Hs[7]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1796]*Hs[7]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1800]*Hs[7]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[0]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[2]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[3]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[0]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[3]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[6]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[8] - kkappa*Gs[9] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[3])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(-1 + Hs[0] + Hs[3]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[0] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[0] + Gsp[17]*Hs[1] + Gsp[33]*Hs[2] + Gsp[49]*Hs[3] + Gsp[65]*Hs[4] + Gsp[81]*Hs[5] + Gsp[97]*Hs[6] + Gsp[113]*Hs[7]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[0] + Gsp[18]*Hs[1] + Gsp[34]*Hs[2] + Gsp[50]*Hs[3] + Gsp[66]*Hs[4] + Gsp[82]*Hs[5] + Gsp[98]*Hs[6] + Gsp[114]*Hs[7]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[0] + Gsp[4]*Hs[0] + Gsp[20]*Hs[1] + Gsp[36]*Hs[2] + rrhoz*Hs[3] + Gsp[52]*Hs[3] + Gsp[68]*Hs[4] + Gsp[84]*Hs[5] + Gsp[100]*Hs[6] + Gsp[116]*Hs[7])))/pow(zbar,rrho) - kkappa*Gs[6]*yss[9]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nxc_sp_s[5]=-(Pssp*Gs[6]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[6] + iiota*zbar*Hs[0] + iiota*zbar*(-1 + Hs[3])) - iiota*Pssp*zbar*(Hs[112] + Hs[115]) + iiota*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[6]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[1]*Gs[225] - pow(E,yss[7])*Pssp*Gs[7]*Gs[231] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[1] - pow(E,yss[7])*Gs[7])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nxc_sp_s[7]=-(pow(E,yss[0])*Pssp*Gs[0]*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[225] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[226] - pow(E,yss[3])*Pssp*Gs[3]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[2] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[2] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[3] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[3] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[6]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[5]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[3]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[5]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[3]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[1]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[3]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha) - pow(E,yss[0])*Gs[0] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] - pow(E,yss[3])*Gs[3] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] - pow(E,yss[2])*pbar*(Gs[2] + Hs[4]) - pow(E,yss[11])*ebar*Hs[6] - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*yss[5] + (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[1])/(1 + yss[5]) - (zbar*Hs[3]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nxc_sp_s[8]=pow(E,yss[3])*Pssp*Gs[3]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[3] - pow(E,xss[0])*(-1 + ddelta + zbar*Hs[0] + zbar*Hs[3])) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(-1 + Hs[0] + Hs[3])*(Hs[112] + Hs[115]) - pow(E,xss[0])*Pssp*zbar*(Hs[0] + Hs[3])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[9]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[6] + Hs[0] + Hs[3])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[5]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[5]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[3]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[5]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[3]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[1]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[3]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[1] + Gs[7])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[2] + Hs[4])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[5]) - Gs[10] + pow(E,xss[0])*kkappa*zbar*(Gs[6] + Hs[0] + Hs[3]) - (zbar*Gs[5]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[1])/(1 + yss[5]) + (zbar*Hs[3]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[1] + Gs[7]) + pow(E,yss[2])*pbar*(Gs[2] + Hs[4]))*(1 + yss[5])) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nxc_sp_s[10]=((-1 + nnus)*Gs[9] + nnus*Gs[10])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nxc_sp_s[11]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[5] - pow(E,bbar - xss[1])*ppsir*Hs[1] + Hs[5]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[1]*Hs[113] + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nxc_sp_s[12]=pow(E,xss[0])*(-(Pssp*Gs[4]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[4] - Hs[0]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(Gs[228] - Hs[112]) + Pssp*Hs[0]*Hs[112]);
	Nxc_sp_s[13]=-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Gs[225]) - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[225] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[2]*Gs[226] + pow(E,yss[11])*Pssp*Gs[11]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[2] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[2] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[3] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[3] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*pow(zbar,aalpha)) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[1] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[2] + pow(E,yss[11])*Gs[11] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[2] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[3] + pow(E,yss[2])*pbar*(Gs[2] + Hs[4])) - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha)*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[1]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[2]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[2]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[3]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[2] + Hs[4])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nxc_sp_s[14]=(Pssp*zbar*(Gs[11] - Hs[3])*Hs[113] + Pssp*zbar*Hs[1]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[11] - Hs[3])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[12] - zbar*Hs[1] + zbar*(Gs[11] - Hs[3])*xss[1]) + (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[15]=(-(Pssp*zbar*Hs[3]*Hs[113]) - Pssp*zbar*Hs[1]*Hs[115] - Pssp*(-1 + zbar)*Gs[11]*Gs[235]*xss[1] - Pssp*zbar*Hs[3]*Hs[115]*xss[1] + Pssp*zbar*Gs[235]*(Hs[1] + Hs[3]*xss[1]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[13]) + zbar*Hs[1] - (-1 + zbar)*Gs[11]*xss[1] + zbar*Hs[3]*xss[1]) + Pssp*zbar*Gs[11]*(Hs[113] + Hs[115]*xss[1]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[16]=pow(E,yss[0] - yss[11])*Pssp*Gs[0]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[3]*Gs[227] - Pssp*Gs[11]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[11]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[11])*Gs[11] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[0] + pow(E,yss[3])*Gs[3] - pow(E,yss[0])*Gs[11] - pow(E,yss[3])*Gs[11] - pow(E,yss[11])*ebar*Gs[11] + pow(E,yss[11])*Gs[14] + pow(E,yss[11])*ebar*Hs[6]))/pow(E,yss[11]) + ebar*Pssp*Hs[6]*Hs[118] - (Pssp*Gs[11]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nxc_sp_s[17]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[3])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[9]*Hs[115])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[9]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[8]*Hs[0]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[24]*Hs[1]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[40]*Hs[2]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[56]*Hs[3]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[72]*Hs[4]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[88]*Hs[5]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[104]*Hs[6]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[120]*Hs[7]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[24]*Hs[0]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[264]*Hs[1]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[280]*Hs[2]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[296]*Hs[3]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[312]*Hs[4]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[328]*Hs[5]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[344]*Hs[6]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[360]*Hs[7]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[40]*Hs[0]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[280]*Hs[1]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[520]*Hs[2]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[536]*Hs[3]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[552]*Hs[4]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[568]*Hs[5]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[584]*Hs[6]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[600]*Hs[7]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[56]*Hs[0]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[296]*Hs[1]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[536]*Hs[2]*Hs[115]*yss[9])/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[3]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[776]*Hs[3]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[792]*Hs[4]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[808]*Hs[5]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[824]*Hs[6]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[840]*Hs[7]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[72]*Hs[0]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[312]*Hs[1]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[552]*Hs[2]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[792]*Hs[3]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1032]*Hs[4]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[5]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[6]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[7]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[88]*Hs[0]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[328]*Hs[1]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[568]*Hs[2]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[808]*Hs[3]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[4]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1288]*Hs[5]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[6]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[7]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[104]*Hs[0]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[344]*Hs[1]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[584]*Hs[2]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[824]*Hs[3]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[4]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[5]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1544]*Hs[6]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[7]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[120]*Hs[0]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[360]*Hs[1]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[600]*Hs[2]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[840]*Hs[3]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[4]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[5]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[6]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1800]*Hs[7]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[3]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(zbar,rrho)*Gs[9])/pow(E,yss[8])) + bbeta*Gs[15] - (rrho*rrhoz*pow(zbar,rrho)*Hs[3]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[0] + Gsp[24]*Hs[1] + Gsp[40]*Hs[2] + Gsp[56]*Hs[3] + Gsp[72]*Hs[4] + Gsp[88]*Hs[5] + Gsp[104]*Hs[6] + Gsp[120]*Hs[7])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[9] + dP1ssp*Gs[10])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxc_sp_s[18]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[2]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[114];
	Nxc_sp_s[19]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[3]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[115];
	Nxc_sp_s[20]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[4]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[116];
	Nxc_sp_s[21]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[7]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[119];
	Nxc_sp_s[22]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[6]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[118];
	Nxc_sp_s[23]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[5]) - (dP2ssp*Gs[9] + dP1ssp*Gs[10])*Hs[117];
	Nxc_sp_s[24]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[16]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[17]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[24]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[15] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])) - pow(E,yss[8])*Gs[24] + Hs[15]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[16] - pow(pow(E,yss[1]),oomega)*Gs[17])*Hs[119] + (Pssp*Hs[15]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxc_sp_s[25]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[226] - (pbar*pphi*Pssp*Gs[25]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[21]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[10] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[11] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[11] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[115] + (pbar*pphi*Pssp*Gs[25]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[24]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[21]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[24]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[12]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[12]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[11] - pbar*Hs[12]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nxc_sp_s[26]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[10] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[11] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[11] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[25]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[21]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[24]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[23]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[23]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[7])*pphi*Gs[23]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[21]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[25] - Gs[24]*yss[9]))) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nxc_sp_s[27]=-(pow(E,yss[8])*Pssp*Gs[24]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[11])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[21]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[21]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[8]*Hs[8]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[9]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[10]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[11]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[12]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[13]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[14]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[15]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[8]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[264]*Hs[9]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[10]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[11]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[12]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[13]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[14]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[15]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[8]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[9]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[520]*Hs[10]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[11]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[12]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[13]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[14]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[15]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[8]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[9]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[10]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[11]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[776]*Hs[11]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[12]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[13]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[14]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[15]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[8]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[9]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[10]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[11]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1032]*Hs[12]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[13]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[14]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[15]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[8]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[9]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[10]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[11]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[12]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1288]*Hs[13]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[14]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[15]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[8]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[9]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[10]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[11]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[12]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[13]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1544]*Hs[14]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[15]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[8]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[9]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[10]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[11]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[12]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[13]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[14]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1800]*Hs[15]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[11]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[21])/pow(zbar,rrho) - pow(E,yss[8])*Gs[24] + Gs[25] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[11]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nxc_sp_s[28]=-(kkappa*Pssp*Gs[25]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[24]*Gs[232] - kkappa*Pssp*Gs[22]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1]*Hs[8]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[2]*Hs[8]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[4]*Hs[8]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[8]*Hs[8]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[9]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[9]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[9]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[9]*Hs[112])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[10]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[10]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[10]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[10]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[11]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[11]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[11]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[11]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[12]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[12]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[12]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[12]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[13]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[13]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[13]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[13]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[14]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[14]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[14]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[14]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[15]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[15]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[15]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[15]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[8]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[8]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[8]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[8]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[257]*Hs[9]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[258]*Hs[9]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[260]*Hs[9]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[264]*Hs[9]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[10]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[10]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[10]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[10]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[11]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[11]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[11]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[11]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[12]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[12]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[12]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[12]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[13]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[13]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[13]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[13]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[14]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[14]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[14]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[14]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[15]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[15]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[15]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[15]*Hs[113])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[8]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[8]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[8]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[8]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[8]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[9]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[9]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[9]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[9]*Hs[114])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[10]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[513]*Hs[10]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[514]*Hs[10]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[516]*Hs[10]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[520]*Hs[10]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[11]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[11]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[11]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[11]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[12]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[12]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[12]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[12]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[13]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[13]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[13]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[13]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[14]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[14]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[14]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[14]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[15]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[15]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[15]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[15]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[8]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[8]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[8]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[8]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[8]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[9]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[9]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[9]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[9]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[10]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[10]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[10]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[10]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[10]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[11]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[769]*Hs[11]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[770]*Hs[11]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[772]*Hs[11]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[776]*Hs[11]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[12]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[12]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[12]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[12]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[13]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[13]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[13]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[13]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[14]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[14]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[14]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[14]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[15]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[15]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[15]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[15]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[24]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[8]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[8]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[8]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[8]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[9]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[9]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[9]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[9]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[10]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[10]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[10]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[10]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[11]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[11]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[11]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[11]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1025]*Hs[12]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1026]*Hs[12]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1028]*Hs[12]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1032]*Hs[12]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[13]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[13]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[13]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[13]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[14]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[14]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[14]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[14]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[15]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[15]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[15]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[15]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[8]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[8]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[8]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[8]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[9]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[9]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[9]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[9]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[10]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[10]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[10]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[10]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[11]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[11]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[11]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[11]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[12]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[12]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[12]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[12]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1281]*Hs[13]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1282]*Hs[13]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1284]*Hs[13]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1288]*Hs[13]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[14]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[14]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[14]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[14]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[15]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[15]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[15]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[15]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[8]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[8]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[8]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[8]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[9]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[9]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[9]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[9]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[10]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[10]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[10]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[10]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[11]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[11]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[11]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[11]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[12]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[12]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[12]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[12]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[13]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[13]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[13]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[13]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1537]*Hs[14]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1538]*Hs[14]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1540]*Hs[14]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1544]*Hs[14]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[15]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[15]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[15]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[15]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[8]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[8]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[8]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[8]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[9]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[9]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[9]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[9]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[10]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[10]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[10]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[10]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[11]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[11]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[11]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[11]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[12]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[12]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[12]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[12]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[13]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[13]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[13]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[13]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[14]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[14]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[14]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[14]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1793]*Hs[15]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1794]*Hs[15]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1796]*Hs[15]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1800]*Hs[15]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[8]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[10]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[11]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[8]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[11]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[22]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[24] - kkappa*Gs[25] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[11])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[8] + Hs[11]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[8] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[8] + Gsp[17]*Hs[9] + Gsp[33]*Hs[10] + Gsp[49]*Hs[11] + Gsp[65]*Hs[12] + Gsp[81]*Hs[13] + Gsp[97]*Hs[14] + Gsp[113]*Hs[15]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[8] + Gsp[18]*Hs[9] + Gsp[34]*Hs[10] + Gsp[50]*Hs[11] + Gsp[66]*Hs[12] + Gsp[82]*Hs[13] + Gsp[98]*Hs[14] + Gsp[114]*Hs[15]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[8] + Gsp[4]*Hs[8] + Gsp[20]*Hs[9] + Gsp[36]*Hs[10] + rrhoz*Hs[11] + Gsp[52]*Hs[11] + Gsp[68]*Hs[12] + Gsp[84]*Hs[13] + Gsp[100]*Hs[14] + Gsp[116]*Hs[15])))/pow(zbar,rrho) - kkappa*Gs[22]*yss[9]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nxc_sp_s[29]=-(Pssp*Gs[22]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[22] + iiota*zbar*(Hs[8] + Hs[11])) + iiota*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[30]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[17]*Gs[225] - pow(E,yss[7])*Pssp*Gs[23]*Gs[231] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[17] - pow(E,yss[7])*Gs[23])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nxc_sp_s[31]=-(pow(E,yss[0])*Pssp*Gs[16]*Gs[224]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[226] - pow(E,yss[3])*Pssp*Gs[19]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[10] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[10] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[11] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[11] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[14]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[21]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[9])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[11]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[21]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[11]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[9]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[11]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(1 - pow(E,yss[0])*Gs[16] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] - pow(E,yss[3])*Gs[19] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] - pow(E,yss[2])*pbar*(Gs[18] + Hs[12]) - pow(E,yss[11])*ebar*Hs[14] - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*yss[5] + (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[9])/(1 + yss[5]) - (zbar*Hs[11]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nxc_sp_s[32]=pow(E,yss[3])*Pssp*Gs[19]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[19] - pow(E,xss[0])*zbar*(Hs[8] + Hs[11])) - pow(E,xss[0])*Pssp*zbar*(Hs[8] + Hs[11])*(Hs[112] + Hs[115]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[8] + Hs[11])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[33]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[22] + Hs[8] + Hs[11])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[21]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[21]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[9])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[11]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[21]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[11]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[9]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[11]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[17] + Gs[23])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[18] + Hs[12])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[21]) - Gs[26] + pow(E,xss[0])*kkappa*zbar*(Gs[22] + Hs[8] + Hs[11]) - (zbar*Gs[21]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[9])/(1 + yss[5]) + (zbar*Hs[11]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[17] + Gs[23]) + pow(E,yss[2])*pbar*(Gs[18] + Hs[12]))*(1 + yss[5])) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nxc_sp_s[34]=((-1 + nnus)*Gs[25] + nnus*Gs[26])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nxc_sp_s[35]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[21] - pow(E,bbar - xss[1])*ppsir*Hs[9] + Hs[13]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[9]*Hs[113] + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nxc_sp_s[36]=pow(E,xss[0])*(-(Pssp*Gs[20]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[20] - Hs[8]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(Gs[228] - Hs[112]) + Pssp*Hs[8]*Hs[112]);
	Nxc_sp_s[37]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[225]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[18]*Gs[226] + pow(E,yss[11])*Pssp*Gs[27]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[10] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[10] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[11] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[11] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[17]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[18] + pow(E,yss[11])*Gs[27] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[10] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[11] + pow(E,yss[2])*pbar*(Gs[18] + Hs[12])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[17]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[18]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[10]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[11]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[18] + Hs[12])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nxc_sp_s[38]=(Pssp*zbar*(Gs[27] - Hs[11])*Hs[113] + Pssp*zbar*Hs[9]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[27] - Hs[11])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[28] - zbar*Hs[9] + zbar*(Gs[27] - Hs[11])*xss[1]) + (dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[39]=-((Pssp*zbar*Hs[11]*Hs[113])/pow(E,yss[11])) - (Pssp*zbar*Hs[9]*Hs[115])/pow(E,yss[11]) - (Pssp*(-1 + zbar)*Gs[27]*Gs[235]*xss[1])/pow(E,yss[11]) - (Pssp*zbar*Hs[11]*Hs[115]*xss[1])/pow(E,yss[11]) + (Pssp*Gs[235]*(-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1]))/pow(E,yss[11]) + (Pssp*zbar*Gs[27]*(Hs[113] + Hs[115]*xss[1]))/pow(E,yss[11]) - ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[29] + ((-1 + zbar)*Gs[27]*xss[1])/pow(E,yss[11]) - (-1 + zbar*Hs[9] + zbar*Hs[11]*xss[1])/pow(E,yss[11]));
	Nxc_sp_s[40]=pow(E,yss[0] - yss[11])*Pssp*Gs[16]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[19]*Gs[227] - Pssp*Gs[27]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[27]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[11])*Gs[27] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[16] + pow(E,yss[3])*Gs[19] - pow(E,yss[0])*Gs[27] - pow(E,yss[3])*Gs[27] - pow(E,yss[11])*ebar*Gs[27] + pow(E,yss[11])*Gs[30] + pow(E,yss[11])*ebar*Hs[14]))/pow(E,yss[11]) + ebar*Pssp*Hs[14]*Hs[118] - (Pssp*Gs[27]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nxc_sp_s[41]=(-((Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[11])/pow(E,yss[8])) + (Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15]))/pow(E,yss[8]) - (Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[25]*Hs[115])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*Gs[25]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[8]*Hs[8]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[24]*Hs[9]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[40]*Hs[10]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[56]*Hs[11]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[72]*Hs[12]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[88]*Hs[13]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[104]*Hs[14]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[120]*Hs[15]*Hs[112]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[24]*Hs[8]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[264]*Hs[9]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[280]*Hs[10]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[296]*Hs[11]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[312]*Hs[12]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[328]*Hs[13]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[344]*Hs[14]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[360]*Hs[15]*Hs[113]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[40]*Hs[8]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[280]*Hs[9]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[520]*Hs[10]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[536]*Hs[11]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[552]*Hs[12]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[568]*Hs[13]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[584]*Hs[14]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[600]*Hs[15]*Hs[114]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[56]*Hs[8]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[296]*Hs[9]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[536]*Hs[10]*Hs[115]*yss[9])/pow(E,yss[8]) - (Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[11]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[776]*Hs[11]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[792]*Hs[12]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[808]*Hs[13]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[824]*Hs[14]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[840]*Hs[15]*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*Hs[115]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[72]*Hs[8]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[312]*Hs[9]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[552]*Hs[10]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[792]*Hs[11]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1032]*Hs[12]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[13]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[14]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[15]*Hs[116]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[88]*Hs[8]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[328]*Hs[9]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[568]*Hs[10]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[808]*Hs[11]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[12]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1288]*Hs[13]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[14]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[15]*Hs[117]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[104]*Hs[8]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[344]*Hs[9]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[584]*Hs[10]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[824]*Hs[11]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[12]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[13]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1544]*Hs[14]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[15]*Hs[118]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[120]*Hs[8]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[360]*Hs[9]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[600]*Hs[10]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[840]*Hs[11]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[12]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[13]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[14]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*pow(zbar,rrho)*G2sp[1800]*Hs[15]*Hs[119]*yss[9])/pow(E,yss[8]) + (Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[11]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])/pow(E,yss[8]) - (Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(zbar,rrho)*Gs[25])/pow(E,yss[8])) + bbeta*Gs[31] - (rrho*rrhoz*pow(zbar,rrho)*Hs[11]*yss[9])/pow(E,yss[8]) + (pow(zbar,rrho)*(Gsp[8]*Hs[8] + Gsp[24]*Hs[9] + Gsp[40]*Hs[10] + Gsp[56]*Hs[11] + Gsp[72]*Hs[12] + Gsp[88]*Hs[13] + Gsp[104]*Hs[14] + Gsp[120]*Hs[15])*yss[9])/pow(E,yss[8])) + ((dP2ssp*Gs[25] + dP1ssp*Gs[26])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/pow(E,yss[8]))/bbeta;
	Nxc_sp_s[42]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[10]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[114];
	Nxc_sp_s[43]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[11]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[115];
	Nxc_sp_s[44]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[12]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[116];
	Nxc_sp_s[45]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[15]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[119];
	Nxc_sp_s[46]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[14]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[118];
	Nxc_sp_s[47]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[13]) - (dP2ssp*Gs[25] + dP1ssp*Gs[26])*Hs[117];
	Nxc_sp_s[48]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[32]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[33]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[40]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[23] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])) - pow(E,yss[8])*Gs[40] + Hs[23]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[32] - pow(pow(E,yss[1]),oomega)*Gs[33])*Hs[119] + (Pssp*Hs[23]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxc_sp_s[49]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[226] - (pbar*pphi*Pssp*Gs[41]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[37]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[18] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[19] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[19] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[115] + (pbar*pphi*Pssp*Gs[41]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[40]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[40]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[37]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[40]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[20]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[20]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[19] - pbar*Hs[20]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nxc_sp_s[50]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[33]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[41]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[18] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[19] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[19] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[41]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[37]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[40]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[39]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[39]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[7])*pphi*Gs[39]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[37]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[41] - Gs[40]*yss[9]))) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nxc_sp_s[51]=-(pow(E,yss[8])*Pssp*Gs[40]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[19])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[37]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[37]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[8]*Hs[16]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[17]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[18]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[19]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[20]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[21]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[22]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[23]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[16]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[264]*Hs[17]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[18]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[19]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[20]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[21]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[22]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[23]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[16]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[17]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[520]*Hs[18]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[19]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[20]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[21]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[22]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[23]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[16]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[17]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[18]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[19]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[776]*Hs[19]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[20]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[21]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[22]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[23]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[16]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[17]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[18]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[19]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1032]*Hs[20]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[21]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[22]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[23]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[16]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[17]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[18]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[19]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[20]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1288]*Hs[21]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[22]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[23]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[16]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[17]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[18]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[19]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[20]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[21]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1544]*Hs[22]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[23]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[16]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[17]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[18]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[19]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[20]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[21]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[22]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1800]*Hs[23]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[19]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[37])/pow(zbar,rrho) - pow(E,yss[8])*Gs[40] + Gs[41] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[19]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nxc_sp_s[52]=-(kkappa*Pssp*Gs[41]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[40]*Gs[232] - kkappa*Pssp*Gs[38]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1]*Hs[16]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[2]*Hs[16]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[4]*Hs[16]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[8]*Hs[16]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[17]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[17]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[17]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[17]*Hs[112])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[18]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[18]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[18]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[18]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[19]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[19]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[19]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[19]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[20]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[20]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[20]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[20]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[21]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[21]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[21]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[21]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[22]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[22]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[22]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[22]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[23]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[23]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[23]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[23]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[16]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[16]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[16]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[16]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[257]*Hs[17]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[258]*Hs[17]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[260]*Hs[17]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[264]*Hs[17]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[18]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[18]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[18]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[18]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[19]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[19]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[19]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[19]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[20]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[20]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[20]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[20]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[21]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[21]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[21]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[21]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[22]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[22]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[22]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[22]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[23]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[23]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[23]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[23]*Hs[113])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[16]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[16]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[16]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[16]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[16]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[17]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[17]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[17]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[17]*Hs[114])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[18]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[513]*Hs[18]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[514]*Hs[18]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[516]*Hs[18]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[520]*Hs[18]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[19]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[19]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[19]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[19]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[20]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[20]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[20]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[20]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[21]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[21]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[21]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[21]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[22]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[22]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[22]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[22]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[23]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[23]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[23]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[23]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[16]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[16]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[16]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[16]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[16]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[17]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[17]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[17]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[17]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[18]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[18]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[18]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[18]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[18]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[19]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[769]*Hs[19]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[770]*Hs[19]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[772]*Hs[19]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[776]*Hs[19]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[20]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[20]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[20]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[20]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[21]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[21]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[21]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[21]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[22]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[22]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[22]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[22]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[23]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[23]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[23]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[23]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[40]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[16]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[16]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[16]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[16]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[17]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[17]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[17]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[17]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[18]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[18]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[18]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[18]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[19]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[19]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[19]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[19]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1025]*Hs[20]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1026]*Hs[20]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1028]*Hs[20]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1032]*Hs[20]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[21]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[21]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[21]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[21]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[22]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[22]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[22]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[22]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[23]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[23]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[23]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[23]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[16]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[16]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[16]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[16]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[17]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[17]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[17]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[17]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[18]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[18]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[18]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[18]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[19]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[19]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[19]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[19]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[20]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[20]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[20]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[20]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1281]*Hs[21]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1282]*Hs[21]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1284]*Hs[21]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1288]*Hs[21]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[22]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[22]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[22]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[22]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[23]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[23]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[23]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[23]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[16]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[16]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[16]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[16]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[17]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[17]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[17]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[17]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[18]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[18]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[18]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[18]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[19]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[19]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[19]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[19]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[20]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[20]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[20]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[20]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[21]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[21]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[21]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[21]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1537]*Hs[22]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1538]*Hs[22]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1540]*Hs[22]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1544]*Hs[22]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[23]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[23]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[23]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[23]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[16]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[16]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[16]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[16]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[17]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[17]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[17]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[17]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[18]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[18]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[18]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[18]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[19]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[19]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[19]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[19]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[20]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[20]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[20]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[20]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[21]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[21]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[21]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[21]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[22]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[22]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[22]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[22]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1793]*Hs[23]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1794]*Hs[23]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1796]*Hs[23]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1800]*Hs[23]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[16]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[18]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[19]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[16]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[19]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[38]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[40] - kkappa*Gs[41] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[19])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[16] + Hs[19]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[16] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[16] + Gsp[17]*Hs[17] + Gsp[33]*Hs[18] + Gsp[49]*Hs[19] + Gsp[65]*Hs[20] + Gsp[81]*Hs[21] + Gsp[97]*Hs[22] + Gsp[113]*Hs[23]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[16] + Gsp[18]*Hs[17] + Gsp[34]*Hs[18] + Gsp[50]*Hs[19] + Gsp[66]*Hs[20] + Gsp[82]*Hs[21] + Gsp[98]*Hs[22] + Gsp[114]*Hs[23]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[16] + Gsp[4]*Hs[16] + Gsp[20]*Hs[17] + Gsp[36]*Hs[18] + rrhoz*Hs[19] + Gsp[52]*Hs[19] + Gsp[68]*Hs[20] + Gsp[84]*Hs[21] + Gsp[100]*Hs[22] + Gsp[116]*Hs[23])))/pow(zbar,rrho) - kkappa*Gs[38]*yss[9]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nxc_sp_s[53]=-(Pssp*Gs[38]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[38] + iiota*zbar*(Hs[16] + Hs[19])) + iiota*Pssp*zbar*(Hs[16] + Hs[19])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[54]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[33]*Gs[225] - pow(E,yss[7])*Pssp*Gs[39]*Gs[231] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[33] - pow(E,yss[7])*Gs[39])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nxc_sp_s[55]=-(pow(E,yss[0])*Pssp*Gs[32]*Gs[224]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[226] - pow(E,yss[3])*Pssp*Gs[35]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[18] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[18] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[19] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[19] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[34] + Hs[20])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[22]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[33] + Gs[39])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[34] + Hs[20])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[37]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[17])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[19]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[37]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[19]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[17]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[19]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[0])*Gs[32]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] - pow(E,yss[3])*Gs[35] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] - pow(E,yss[2])*pbar*(Gs[34] + Hs[20]) - pow(E,yss[11])*ebar*Hs[22] - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*yss[5] + (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[17])/(1 + yss[5]) - (zbar*Hs[19]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nxc_sp_s[56]=pow(E,yss[3])*Pssp*Gs[35]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[35] - pow(E,xss[0])*zbar*(Hs[16] + Hs[19])) - pow(E,xss[0])*Pssp*zbar*(Hs[16] + Hs[19])*(Hs[112] + Hs[115]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[16] + Hs[19])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[57]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[38] + Hs[16] + Hs[19])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[37]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[37]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[17])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[19]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[37]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[19]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[17]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[19]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[33] + Gs[39])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[34] + Hs[20])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[37]) - Gs[42] + pow(E,xss[0])*kkappa*zbar*(Gs[38] + Hs[16] + Hs[19]) - (zbar*Gs[37]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[17])/(1 + yss[5]) + (zbar*Hs[19]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[33] + Gs[39]) + pow(E,yss[2])*pbar*(Gs[34] + Hs[20]))*(1 + yss[5])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nxc_sp_s[58]=((-1 + nnus)*Gs[41] + nnus*Gs[42])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nxc_sp_s[59]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[37] - pow(E,bbar - xss[1])*ppsir*Hs[17] + Hs[21]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[17]*Hs[113] + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nxc_sp_s[60]=pow(E,xss[0])*(-(Pssp*Gs[36]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[36] - Hs[16]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(Gs[228] - Hs[112]) + Pssp*Hs[16]*Hs[112]);
	Nxc_sp_s[61]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[225]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[34]*Gs[226] + pow(E,yss[11])*Pssp*Gs[43]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[18] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[18] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[19] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[19] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[33]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[34] + pow(E,yss[11])*Gs[43] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[18] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[19] + pow(E,yss[2])*pbar*(Gs[34] + Hs[20])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[33]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[34]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[18]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[19]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[34] + Hs[20])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nxc_sp_s[62]=(Pssp*zbar*(Gs[43] - Hs[19])*Hs[113] + Pssp*zbar*Hs[17]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[43] - Hs[19])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[44] - zbar*Hs[17] + zbar*(Gs[43] - Hs[19])*xss[1]) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[63]=(-(Pssp*zbar*Hs[19]*Hs[113]) - Pssp*zbar*Hs[17]*Hs[115] - Pssp*(-1 + zbar)*Gs[43]*Gs[235]*xss[1] - Pssp*zbar*Hs[19]*Hs[115]*xss[1] + Pssp*zbar*Gs[235]*(Hs[17] + Hs[19]*xss[1]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[45]) + zbar*Hs[17] - (-1 + zbar)*Gs[43]*xss[1] + zbar*Hs[19]*xss[1]) + Pssp*zbar*Gs[43]*(Hs[113] + Hs[115]*xss[1]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[64]=pow(E,yss[0] - yss[11])*Pssp*Gs[32]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[35]*Gs[227] - Pssp*Gs[43]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[43]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[11])*Gs[43] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[32] + pow(E,yss[3])*Gs[35] - pow(E,yss[0])*Gs[43] - pow(E,yss[3])*Gs[43] - pow(E,yss[11])*ebar*Gs[43] + pow(E,yss[11])*Gs[46] + pow(E,yss[11])*ebar*Hs[22]))/pow(E,yss[11]) + ebar*Pssp*Hs[22]*Hs[118] - (Pssp*Gs[43]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[41] + dP1ssp*Gs[42])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nxc_sp_s[65]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[19]) + Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[41]*Hs[115] + Pssp*pow(zbar,rrho)*Gs[41]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]) + Pssp*pow(zbar,rrho)*G2sp[8]*Hs[16]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[24]*Hs[17]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[40]*Hs[18]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[56]*Hs[19]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[72]*Hs[20]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[88]*Hs[21]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[104]*Hs[22]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[120]*Hs[23]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[24]*Hs[16]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[264]*Hs[17]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[280]*Hs[18]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[296]*Hs[19]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[312]*Hs[20]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[328]*Hs[21]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[344]*Hs[22]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[360]*Hs[23]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[40]*Hs[16]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[280]*Hs[17]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[520]*Hs[18]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[536]*Hs[19]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[552]*Hs[20]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[568]*Hs[21]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[584]*Hs[22]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[600]*Hs[23]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[56]*Hs[16]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[296]*Hs[17]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[536]*Hs[18]*Hs[115]*yss[9] - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[19]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[776]*Hs[19]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[792]*Hs[20]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[808]*Hs[21]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[824]*Hs[22]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[840]*Hs[23]*Hs[115]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[72]*Hs[16]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[312]*Hs[17]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[552]*Hs[18]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[792]*Hs[19]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1032]*Hs[20]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[21]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[22]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[23]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[88]*Hs[16]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[328]*Hs[17]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[568]*Hs[18]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[808]*Hs[19]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[20]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1288]*Hs[21]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[22]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[23]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[104]*Hs[16]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[344]*Hs[17]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[584]*Hs[18]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[824]*Hs[19]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[20]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[21]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1544]*Hs[22]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[23]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[120]*Hs[16]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[360]*Hs[17]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[600]*Hs[18]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[840]*Hs[19]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[20]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[21]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[22]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1800]*Hs[23]*Hs[119]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[19]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[16] + Gsp[24]*Hs[17] + Gsp[40]*Hs[18] + Gsp[56]*Hs[19] + Gsp[72]*Hs[20] + Gsp[88]*Hs[21] + Gsp[104]*Hs[22] + Gsp[120]*Hs[23])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(bbeta*pow(E,yss[8])*Gs[47] + pow(zbar,rrho)*Gsp[120]*Hs[23]*yss[9] + pow(zbar,rrho)*(-Gs[41] + Gsp[8]*Hs[16]*yss[9] + Gsp[24]*Hs[17]*yss[9] + Gsp[40]*Hs[18]*yss[9] - rrho*rrhoz*Hs[19]*yss[9] + Gsp[56]*Hs[19]*yss[9] + Gsp[72]*Hs[20]*yss[9] + Gsp[88]*Hs[21]*yss[9] + Gsp[104]*Hs[22]*yss[9])) + (dP2ssp*Gs[41] + dP1ssp*Gs[42])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nxc_sp_s[66]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(rrhoa - Hs[18]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[114];
	Nxc_sp_s[67]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[19]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[115];
	Nxc_sp_s[68]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[20]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[116];
	Nxc_sp_s[69]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[23]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[119];
	Nxc_sp_s[70]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[22]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[118];
	Nxc_sp_s[71]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[21]) - (dP2ssp*Gs[41] + dP1ssp*Gs[42])*Hs[117];
	Nxc_sp_s[72]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[48]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[49]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[56]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[31] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49])) - pow(E,yss[8])*Gs[56] + Hs[31]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[48] - pow(pow(E,yss[1]),oomega)*Gs[49])*Hs[119] + (Pssp*Hs[31]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxc_sp_s[73]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[50]*Gs[226] - (pbar*pphi*Pssp*Gs[57]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[53]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[26] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[26] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[27] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[27] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[26]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[27]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[26]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[27]*Hs[115] + (pbar*pphi*Pssp*Gs[57]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[56]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[56]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[53]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[56]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[28]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[28]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[49]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[50] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[27] - pbar*Hs[28]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nxc_sp_s[74]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[49]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[50]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[57]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[53]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[26] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[27] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[27] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[26]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[27]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[26]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[27]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[57]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[56]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[56]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[53]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[56]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[55]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[55]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[49]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[49] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[26] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[27] - pow(E,yss[7])*pphi*Gs[55]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[53]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[57] - Gs[56]*yss[9]))) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nxc_sp_s[75]=-(pow(E,yss[8])*Pssp*Gs[56]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[27])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[53]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[53]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[8]*Hs[24]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[25]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[26]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[27]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[28]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[29]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[30]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[31]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[24]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[264]*Hs[25]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[26]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[27]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[28]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[29]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[30]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[31]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[24]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[25]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[520]*Hs[26]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[27]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[28]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[29]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[30]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[31]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[24]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[25]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[26]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[27]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[776]*Hs[27]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[28]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[29]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[30]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[31]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[24]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[25]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[26]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[27]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1032]*Hs[28]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[29]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[30]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[31]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[24]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[25]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[26]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[27]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[28]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1288]*Hs[29]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[30]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[31]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[24]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[25]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[26]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[27]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[28]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[29]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1544]*Hs[30]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[31]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[24]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[25]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[26]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[27]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[28]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[29]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[30]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1800]*Hs[31]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[27]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[53])/pow(zbar,rrho) - pow(E,yss[8])*Gs[56] + Gs[57] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[27]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nxc_sp_s[76]=-(kkappa*Pssp*Gs[57]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[56]*Gs[232] - kkappa*Pssp*Gs[54]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[24]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[24]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1]*Hs[24]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[2]*Hs[24]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[4]*Hs[24]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[8]*Hs[24]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[25]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[25]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[25]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[25]*Hs[112])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[26]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[26]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[26]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[26]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[26]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[27]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[27]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[27]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[27]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[27]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[28]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[28]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[28]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[28]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[29]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[29]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[29]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[29]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[30]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[30]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[30]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[30]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[31]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[31]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[31]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[31]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[24]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[24]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[24]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[24]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[257]*Hs[25]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[258]*Hs[25]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[260]*Hs[25]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[264]*Hs[25]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[26]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[26]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[26]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[26]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[27]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[27]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[27]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[27]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[28]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[28]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[28]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[28]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[29]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[29]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[29]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[29]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[30]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[30]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[30]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[30]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[31]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[31]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[31]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[31]*Hs[113])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[24]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[24]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[24]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[24]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[24]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[25]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[25]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[25]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[25]*Hs[114])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[26]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[513]*Hs[26]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[514]*Hs[26]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[516]*Hs[26]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[520]*Hs[26]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[27]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[27]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[27]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[27]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[27]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[28]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[28]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[28]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[28]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[29]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[29]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[29]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[29]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[30]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[30]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[30]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[30]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[31]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[31]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[31]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[31]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[24]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[24]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[24]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[24]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[24]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[25]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[25]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[25]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[25]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[26]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[26]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[26]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[26]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[26]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[27]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[27]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[769]*Hs[27]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[770]*Hs[27]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[772]*Hs[27]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[776]*Hs[27]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[28]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[28]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[28]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[28]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[29]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[29]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[29]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[29]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[30]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[30]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[30]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[30]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[31]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[31]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[31]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[31]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[24] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[56]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[24] + Hs[27])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[24]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[24]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[24]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[24]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[25]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[25]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[25]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[25]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[26]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[26]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[26]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[26]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[27]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[27]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[27]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[27]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1025]*Hs[28]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1026]*Hs[28]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1028]*Hs[28]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1032]*Hs[28]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[29]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[29]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[29]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[29]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[30]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[30]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[30]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[30]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[31]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[31]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[31]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[31]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[24]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[24]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[24]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[24]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[25]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[25]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[25]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[25]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[26]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[26]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[26]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[26]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[27]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[27]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[27]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[27]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[28]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[28]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[28]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[28]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1281]*Hs[29]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1282]*Hs[29]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1284]*Hs[29]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1288]*Hs[29]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[30]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[30]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[30]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[30]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[31]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[31]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[31]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[31]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[24]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[24]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[24]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[24]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[25]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[25]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[25]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[25]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[26]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[26]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[26]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[26]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[27]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[27]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[27]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[27]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[28]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[28]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[28]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[28]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[29]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[29]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[29]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[29]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1537]*Hs[30]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1538]*Hs[30]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1540]*Hs[30]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1544]*Hs[30]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[31]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[31]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[31]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[31]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[24]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[24]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[24]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[24]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[25]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[25]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[25]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[25]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[26]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[26]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[26]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[26]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[27]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[27]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[27]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[27]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[28]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[28]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[28]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[28]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[29]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[29]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[29]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[29]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[30]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[30]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[30]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[30]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1793]*Hs[31]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1794]*Hs[31]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1796]*Hs[31]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1800]*Hs[31]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[24]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[26]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[27]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[24]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[26]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[27]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[24]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[27]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[24] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[27]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[54]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[56] - kkappa*Gs[57] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[27])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[24] + Hs[27]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[24] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[24] + Gsp[17]*Hs[25] + Gsp[33]*Hs[26] + Gsp[49]*Hs[27] + Gsp[65]*Hs[28] + Gsp[81]*Hs[29] + Gsp[97]*Hs[30] + Gsp[113]*Hs[31]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[24] + Gsp[18]*Hs[25] + Gsp[34]*Hs[26] + Gsp[50]*Hs[27] + Gsp[66]*Hs[28] + Gsp[82]*Hs[29] + Gsp[98]*Hs[30] + Gsp[114]*Hs[31]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[24] + Gsp[4]*Hs[24] + Gsp[20]*Hs[25] + Gsp[36]*Hs[26] + rrhoz*Hs[27] + Gsp[52]*Hs[27] + Gsp[68]*Hs[28] + Gsp[84]*Hs[29] + Gsp[100]*Hs[30] + Gsp[116]*Hs[31])))/pow(zbar,rrho) - kkappa*Gs[54]*yss[9]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nxc_sp_s[77]=-(Pssp*Gs[54]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[54] + iiota*zbar*(Hs[24] + Hs[27])) + iiota*Pssp*zbar*(Hs[24] + Hs[27])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[78]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[49]*Gs[225] - pow(E,yss[7])*Pssp*Gs[55]*Gs[231] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[49] - pow(E,yss[7])*Gs[55])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nxc_sp_s[79]=-(pow(E,yss[0])*Pssp*Gs[48]*Gs[224]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[50]*Gs[226] - pow(E,yss[3])*Pssp*Gs[51]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[26] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[26] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[27] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[27] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[26]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[27]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[26]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[27]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[50] + Hs[28])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[53]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[30]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[49] + Gs[55])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[50] + Hs[28])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[53]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[25])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[53]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[27]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[53]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[27]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[25]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[27]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[0])*Gs[48]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[49] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[50] - pow(E,yss[3])*Gs[51] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[53] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[26] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[27] - pow(E,yss[2])*pbar*(Gs[50] + Hs[28]) - pow(E,yss[11])*ebar*Hs[30] - pphi*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28]))*yss[5] + (zbar*Gs[53]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[25])/(1 + yss[5]) - (zbar*Hs[27]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nxc_sp_s[80]=pow(E,yss[3])*Pssp*Gs[51]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[51] - pow(E,xss[0])*zbar*(Hs[24] + Hs[27])) - pow(E,xss[0])*Pssp*zbar*(Hs[24] + Hs[27])*(Hs[112] + Hs[115]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[24] + Hs[27])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[81]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[54] + Hs[24] + Hs[27])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[53]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[53]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[25])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[53]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[27]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[53]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[27]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[25]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[27]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[49] + Gs[55])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[50] + Hs[28])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[53]) - Gs[58] + pow(E,xss[0])*kkappa*zbar*(Gs[54] + Hs[24] + Hs[27]) - (zbar*Gs[53]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[25])/(1 + yss[5]) + (zbar*Hs[27]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[49] + Gs[55]) + pow(E,yss[2])*pbar*(Gs[50] + Hs[28]))*(1 + yss[5])) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nxc_sp_s[82]=((-1 + nnus)*Gs[57] + nnus*Gs[58])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nxc_sp_s[83]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[53] - pow(E,bbar - xss[1])*ppsir*Hs[25] + Hs[29]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[25]*Hs[113] + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nxc_sp_s[84]=pow(E,xss[0])*(-(Pssp*Gs[52]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[52] - Hs[24]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(Gs[228] - Hs[112]) + Pssp*Hs[24]*Hs[112]);
	Nxc_sp_s[85]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Gs[225]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[50]*Gs[226] + pow(E,yss[11])*Pssp*Gs[59]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[26] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[26] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[27] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[27] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[49]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[50] + pow(E,yss[11])*Gs[59] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[26] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[27] + pow(E,yss[2])*pbar*(Gs[50] + Hs[28])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[26]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[27]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[49]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[50]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[26]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[27]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[50] + Hs[28])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nxc_sp_s[86]=(Pssp*zbar*(Gs[59] - Hs[27])*Hs[113] + Pssp*zbar*Hs[25]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[59] - Hs[27])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[60] - zbar*Hs[25] + zbar*(Gs[59] - Hs[27])*xss[1]) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[87]=(-(Pssp*zbar*Hs[27]*Hs[113]) - Pssp*zbar*Hs[25]*Hs[115] - Pssp*(-1 + zbar)*Gs[59]*Gs[235]*xss[1] - Pssp*zbar*Hs[27]*Hs[115]*xss[1] + Pssp*zbar*Gs[235]*(Hs[25] + Hs[27]*xss[1]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[61]) + zbar*Hs[25] - (-1 + zbar)*Gs[59]*xss[1] + zbar*Hs[27]*xss[1]) + Pssp*zbar*Gs[59]*(Hs[113] + Hs[115]*xss[1]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[88]=pow(E,yss[0] - yss[11])*Pssp*Gs[48]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[51]*Gs[227] - Pssp*Gs[59]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[59]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[48] + pow(E,yss[3])*Gs[51] - pow(E,yss[11])*Gs[59] + pow(E,yss[11])*ebar*Hs[30]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[48] + pow(E,yss[3])*Gs[51] - pow(E,yss[0])*Gs[59] - pow(E,yss[3])*Gs[59] - pow(E,yss[11])*ebar*Gs[59] + pow(E,yss[11])*Gs[62] + pow(E,yss[11])*ebar*Hs[30]))/pow(E,yss[11]) + ebar*Pssp*Hs[30]*Hs[118] - (Pssp*Gs[59]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[57] + dP1ssp*Gs[58])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nxc_sp_s[89]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[27]) + Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[57]*Hs[115] + Pssp*pow(zbar,rrho)*Gs[57]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]) + Pssp*pow(zbar,rrho)*G2sp[8]*Hs[24]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[24]*Hs[25]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[40]*Hs[26]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[56]*Hs[27]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[72]*Hs[28]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[88]*Hs[29]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[104]*Hs[30]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[120]*Hs[31]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[24]*Hs[24]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[264]*Hs[25]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[280]*Hs[26]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[296]*Hs[27]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[312]*Hs[28]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[328]*Hs[29]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[344]*Hs[30]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[360]*Hs[31]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[40]*Hs[24]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[280]*Hs[25]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[520]*Hs[26]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[536]*Hs[27]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[552]*Hs[28]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[568]*Hs[29]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[584]*Hs[30]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[600]*Hs[31]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[56]*Hs[24]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[296]*Hs[25]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[536]*Hs[26]*Hs[115]*yss[9] - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[27]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[776]*Hs[27]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[792]*Hs[28]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[808]*Hs[29]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[824]*Hs[30]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[840]*Hs[31]*Hs[115]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[72]*Hs[24]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[312]*Hs[25]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[552]*Hs[26]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[792]*Hs[27]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1032]*Hs[28]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[29]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[30]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[31]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[88]*Hs[24]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[328]*Hs[25]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[568]*Hs[26]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[808]*Hs[27]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[28]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1288]*Hs[29]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[30]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[31]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[104]*Hs[24]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[344]*Hs[25]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[584]*Hs[26]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[824]*Hs[27]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[28]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[29]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1544]*Hs[30]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[31]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[120]*Hs[24]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[360]*Hs[25]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[600]*Hs[26]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[840]*Hs[27]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[28]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[29]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[30]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1800]*Hs[31]*Hs[119]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[27]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[24] + Gsp[24]*Hs[25] + Gsp[40]*Hs[26] + Gsp[56]*Hs[27] + Gsp[72]*Hs[28] + Gsp[88]*Hs[29] + Gsp[104]*Hs[30] + Gsp[120]*Hs[31])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(bbeta*pow(E,yss[8])*Gs[63] + pow(zbar,rrho)*Gsp[120]*Hs[31]*yss[9] + pow(zbar,rrho)*(-Gs[57] + Gsp[8]*Hs[24]*yss[9] + Gsp[24]*Hs[25]*yss[9] + Gsp[40]*Hs[26]*yss[9] - rrho*rrhoz*Hs[27]*yss[9] + Gsp[56]*Hs[27]*yss[9] + Gsp[72]*Hs[28]*yss[9] + Gsp[88]*Hs[29]*yss[9] + Gsp[104]*Hs[30]*yss[9])) + (dP2ssp*Gs[57] + dP1ssp*Gs[58])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nxc_sp_s[90]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[26]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[114];
	Nxc_sp_s[91]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(rrhoz - Hs[27]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[115];
	Nxc_sp_s[92]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[28]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[116];
	Nxc_sp_s[93]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[31]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[119];
	Nxc_sp_s[94]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[30]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[118];
	Nxc_sp_s[95]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[29]) - (dP2ssp*Gs[57] + dP1ssp*Gs[58])*Hs[117];
	Nxc_sp_s[96]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[64]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[65]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[64] - pow(pow(E,yss[1]),oomega)*Gs[65])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[72]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[39] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[64] - pow(pow(E,yss[1]),oomega)*Gs[65])) - pow(E,yss[8])*Gs[72] + Hs[39]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[64] - pow(pow(E,yss[1]),oomega)*Gs[65])*Hs[119] + (Pssp*Hs[39]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxc_sp_s[97]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[66]*Gs[226] - (pbar*pphi*Pssp*Gs[73]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[69]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[34] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[34] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[35] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[35] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[34]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[35]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[34]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[35]*Hs[115] + (pbar*pphi*Pssp*Gs[73]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[72]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[72]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[69]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[72]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[36]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[36]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[65]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[66] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[35] - pbar*Hs[36]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nxc_sp_s[98]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[65]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[66]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[73]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[69]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[34] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[35] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[35] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[34]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[35]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[34]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[35]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[73]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[72]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[72]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[69]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[72]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[71]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[71]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[65]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[65] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[66] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[34] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[35] - pow(E,yss[7])*pphi*Gs[71]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[69]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[73] - Gs[72]*yss[9]))) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nxc_sp_s[99]=-(pow(E,yss[8])*Pssp*Gs[72]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[35])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[69]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[69]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[8]*Hs[32]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[33]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[34]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[35]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[36]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[37]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[38]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[39]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[32]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[264]*Hs[33]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[34]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[35]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[36]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[37]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[38]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[39]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[32]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[33]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[520]*Hs[34]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[35]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[36]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[37]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[38]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[39]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[32]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[33]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[34]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[35]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[776]*Hs[35]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[36]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[37]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[38]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[39]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[32]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[33]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[34]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[35]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1032]*Hs[36]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[37]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[38]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[39]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[32]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[33]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[34]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[35]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[36]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1288]*Hs[37]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[38]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[39]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[32]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[33]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[34]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[35]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[36]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[37]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1544]*Hs[38]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[39]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[32]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[33]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[34]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[35]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[36]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[37]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[38]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1800]*Hs[39]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[35]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[69])/pow(zbar,rrho) - pow(E,yss[8])*Gs[72] + Gs[73] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[35]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nxc_sp_s[100]=-(kkappa*Pssp*Gs[73]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[72]*Gs[232] - kkappa*Pssp*Gs[70]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[32]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[32]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1]*Hs[32]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[2]*Hs[32]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[4]*Hs[32]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[8]*Hs[32]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[33]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[33]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[33]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[33]*Hs[112])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[34]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[34]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[34]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[34]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[34]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[35]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[35]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[35]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[35]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[35]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[36]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[36]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[36]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[36]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[37]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[37]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[37]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[37]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[38]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[38]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[38]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[38]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[39]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[39]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[39]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[39]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[32]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[32]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[32]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[32]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[257]*Hs[33]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[258]*Hs[33]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[260]*Hs[33]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[264]*Hs[33]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[34]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[34]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[34]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[34]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[35]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[35]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[35]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[35]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[36]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[36]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[36]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[36]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[37]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[37]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[37]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[37]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[38]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[38]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[38]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[38]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[39]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[39]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[39]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[39]*Hs[113])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[32]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[32]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[32]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[32]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[32]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[33]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[33]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[33]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[33]*Hs[114])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[34]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[513]*Hs[34]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[514]*Hs[34]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[516]*Hs[34]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[520]*Hs[34]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[35]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[35]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[35]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[35]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[35]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[36]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[36]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[36]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[36]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[37]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[37]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[37]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[37]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[38]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[38]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[38]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[38]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[39]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[39]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[39]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[39]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[32]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[32]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[32]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[32]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[32]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[33]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[33]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[33]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[33]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[34]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[34]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[34]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[34]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[34]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[35]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[35]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[769]*Hs[35]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[770]*Hs[35]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[772]*Hs[35]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[776]*Hs[35]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[36]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[36]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[36]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[36]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[37]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[37]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[37]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[37]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[38]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[38]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[38]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[38]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[39]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[39]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[39]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[39]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[32] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[72]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[32] + Hs[35])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[32]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[32]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[32]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[32]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[33]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[33]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[33]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[33]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[34]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[34]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[34]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[34]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[35]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[35]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[35]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[35]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1025]*Hs[36]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1026]*Hs[36]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1028]*Hs[36]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1032]*Hs[36]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[37]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[37]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[37]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[37]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[38]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[38]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[38]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[38]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[39]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[39]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[39]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[39]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[32]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[32]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[32]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[32]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[33]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[33]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[33]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[33]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[34]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[34]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[34]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[34]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[35]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[35]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[35]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[35]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[36]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[36]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[36]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[36]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1281]*Hs[37]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1282]*Hs[37]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1284]*Hs[37]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1288]*Hs[37]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[38]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[38]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[38]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[38]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[39]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[39]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[39]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[39]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[32]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[32]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[32]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[32]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[33]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[33]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[33]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[33]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[34]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[34]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[34]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[34]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[35]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[35]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[35]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[35]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[36]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[36]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[36]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[36]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[37]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[37]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[37]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[37]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1537]*Hs[38]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1538]*Hs[38]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1540]*Hs[38]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1544]*Hs[38]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[39]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[39]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[39]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[39]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[32]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[32]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[32]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[32]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[33]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[33]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[33]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[33]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[34]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[34]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[34]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[34]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[35]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[35]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[35]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[35]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[36]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[36]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[36]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[36]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[37]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[37]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[37]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[37]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[38]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[38]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[38]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[38]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1793]*Hs[39]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1794]*Hs[39]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1796]*Hs[39]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1800]*Hs[39]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[32]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[34]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[35]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[32]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[34]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[35]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[32]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[35]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[32] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[35]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[70]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[72] - kkappa*Gs[73] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[35])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[32] + Hs[35]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[32] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[32] + Gsp[17]*Hs[33] + Gsp[33]*Hs[34] + Gsp[49]*Hs[35] + Gsp[65]*Hs[36] + Gsp[81]*Hs[37] + Gsp[97]*Hs[38] + Gsp[113]*Hs[39]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[32] + Gsp[18]*Hs[33] + Gsp[34]*Hs[34] + Gsp[50]*Hs[35] + Gsp[66]*Hs[36] + Gsp[82]*Hs[37] + Gsp[98]*Hs[38] + Gsp[114]*Hs[39]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[32] + Gsp[4]*Hs[32] + Gsp[20]*Hs[33] + Gsp[36]*Hs[34] + rrhoz*Hs[35] + Gsp[52]*Hs[35] + Gsp[68]*Hs[36] + Gsp[84]*Hs[37] + Gsp[100]*Hs[38] + Gsp[116]*Hs[39])))/pow(zbar,rrho) - kkappa*Gs[70]*yss[9]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nxc_sp_s[101]=-(Pssp*Gs[70]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[70] + iiota*zbar*(Hs[32] + Hs[35])) + iiota*Pssp*zbar*(Hs[32] + Hs[35])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[102]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[65]*Gs[225] - pow(E,yss[7])*Pssp*Gs[71]*Gs[231] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[65] - pow(E,yss[7])*Gs[71])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nxc_sp_s[103]=-(pow(E,yss[0])*Pssp*Gs[64]*Gs[224]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[66]*Gs[226] - pow(E,yss[3])*Pssp*Gs[67]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[34] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[34] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[35] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[35] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[34]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[35]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[34]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[35]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[66] + Hs[36])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[69]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[38]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[65] + Gs[71])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[66] + Hs[36])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[69]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[33])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[69]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[35]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[69]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[35]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[33]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[35]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[0])*Gs[64]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[65] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[66] - pow(E,yss[3])*Gs[67] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[69] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[34] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[35] - pow(E,yss[2])*pbar*(Gs[66] + Hs[36]) - pow(E,yss[11])*ebar*Hs[38] - pphi*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36]))*yss[5] + (zbar*Gs[69]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[33])/(1 + yss[5]) - (zbar*Hs[35]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nxc_sp_s[104]=pow(E,yss[3])*Pssp*Gs[67]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[67] - pow(E,xss[0])*zbar*(Hs[32] + Hs[35])) - pow(E,xss[0])*Pssp*zbar*(Hs[32] + Hs[35])*(Hs[112] + Hs[115]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[32] + Hs[35])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[105]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[70] + Hs[32] + Hs[35])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[69]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[69]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[33])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[69]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[35]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[69]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[35]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[33]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[35]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[65] + Gs[71])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[66] + Hs[36])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[69]) - Gs[74] + pow(E,xss[0])*kkappa*zbar*(Gs[70] + Hs[32] + Hs[35]) - (zbar*Gs[69]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[33])/(1 + yss[5]) + (zbar*Hs[35]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[65] + Gs[71]) + pow(E,yss[2])*pbar*(Gs[66] + Hs[36]))*(1 + yss[5])) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nxc_sp_s[106]=((-1 + nnus)*Gs[73] + nnus*Gs[74])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nxc_sp_s[107]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[69] - pow(E,bbar - xss[1])*ppsir*Hs[33] + Hs[37]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[33]*Hs[113] + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nxc_sp_s[108]=pow(E,xss[0])*(-(Pssp*Gs[68]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[68] - Hs[32]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(Gs[228] - Hs[112]) + Pssp*Hs[32]*Hs[112]);
	Nxc_sp_s[109]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Gs[225]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[66]*Gs[226] + pow(E,yss[11])*Pssp*Gs[75]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[34] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[34] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[35] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[35] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[65]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[66] + pow(E,yss[11])*Gs[75] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[34] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[35] + pow(E,yss[2])*pbar*(Gs[66] + Hs[36])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[34]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[35]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[65]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[66]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[34]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[35]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[66] + Hs[36])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nxc_sp_s[110]=(Pssp*zbar*(Gs[75] - Hs[35])*Hs[113] + Pssp*zbar*Hs[33]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[75] - Hs[35])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[76] - zbar*Hs[33] + zbar*(Gs[75] - Hs[35])*xss[1]) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[111]=(-(Pssp*zbar*Hs[35]*Hs[113]) - Pssp*zbar*Hs[33]*Hs[115] - Pssp*(-1 + zbar)*Gs[75]*Gs[235]*xss[1] - Pssp*zbar*Hs[35]*Hs[115]*xss[1] + Pssp*zbar*Gs[235]*(Hs[33] + Hs[35]*xss[1]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[77]) + zbar*Hs[33] - (-1 + zbar)*Gs[75]*xss[1] + zbar*Hs[35]*xss[1]) + Pssp*zbar*Gs[75]*(Hs[113] + Hs[115]*xss[1]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[112]=pow(E,yss[0] - yss[11])*Pssp*Gs[64]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[67]*Gs[227] - Pssp*Gs[75]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[75]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[64] + pow(E,yss[3])*Gs[67] - pow(E,yss[11])*Gs[75] + pow(E,yss[11])*ebar*Hs[38]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[64] + pow(E,yss[3])*Gs[67] - pow(E,yss[0])*Gs[75] - pow(E,yss[3])*Gs[75] - pow(E,yss[11])*ebar*Gs[75] + pow(E,yss[11])*Gs[78] + pow(E,yss[11])*ebar*Hs[38]))/pow(E,yss[11]) + ebar*Pssp*Hs[38]*Hs[118] - (Pssp*Gs[75]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[73] + dP1ssp*Gs[74])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nxc_sp_s[113]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[35]) + Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[73]*Hs[115] + Pssp*pow(zbar,rrho)*Gs[73]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]) + Pssp*pow(zbar,rrho)*G2sp[8]*Hs[32]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[24]*Hs[33]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[40]*Hs[34]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[56]*Hs[35]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[72]*Hs[36]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[88]*Hs[37]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[104]*Hs[38]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[120]*Hs[39]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[24]*Hs[32]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[264]*Hs[33]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[280]*Hs[34]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[296]*Hs[35]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[312]*Hs[36]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[328]*Hs[37]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[344]*Hs[38]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[360]*Hs[39]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[40]*Hs[32]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[280]*Hs[33]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[520]*Hs[34]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[536]*Hs[35]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[552]*Hs[36]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[568]*Hs[37]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[584]*Hs[38]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[600]*Hs[39]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[56]*Hs[32]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[296]*Hs[33]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[536]*Hs[34]*Hs[115]*yss[9] - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[35]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[776]*Hs[35]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[792]*Hs[36]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[808]*Hs[37]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[824]*Hs[38]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[840]*Hs[39]*Hs[115]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[72]*Hs[32]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[312]*Hs[33]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[552]*Hs[34]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[792]*Hs[35]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1032]*Hs[36]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[37]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[38]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[39]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[88]*Hs[32]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[328]*Hs[33]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[568]*Hs[34]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[808]*Hs[35]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[36]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1288]*Hs[37]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[38]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[39]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[104]*Hs[32]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[344]*Hs[33]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[584]*Hs[34]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[824]*Hs[35]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[36]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[37]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1544]*Hs[38]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[39]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[120]*Hs[32]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[360]*Hs[33]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[600]*Hs[34]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[840]*Hs[35]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[36]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[37]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[38]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1800]*Hs[39]*Hs[119]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[35]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[32] + Gsp[24]*Hs[33] + Gsp[40]*Hs[34] + Gsp[56]*Hs[35] + Gsp[72]*Hs[36] + Gsp[88]*Hs[37] + Gsp[104]*Hs[38] + Gsp[120]*Hs[39])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(bbeta*pow(E,yss[8])*Gs[79] + pow(zbar,rrho)*Gsp[120]*Hs[39]*yss[9] + pow(zbar,rrho)*(-Gs[73] + Gsp[8]*Hs[32]*yss[9] + Gsp[24]*Hs[33]*yss[9] + Gsp[40]*Hs[34]*yss[9] - rrho*rrhoz*Hs[35]*yss[9] + Gsp[56]*Hs[35]*yss[9] + Gsp[72]*Hs[36]*yss[9] + Gsp[88]*Hs[37]*yss[9] + Gsp[104]*Hs[38]*yss[9])) + (dP2ssp*Gs[73] + dP1ssp*Gs[74])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nxc_sp_s[114]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[34]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[114];
	Nxc_sp_s[115]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[35]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[115];
	Nxc_sp_s[116]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(rrhop - Hs[36]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[116];
	Nxc_sp_s[117]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[39]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[119];
	Nxc_sp_s[118]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[38]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[118];
	Nxc_sp_s[119]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[37]) - (dP2ssp*Gs[73] + dP1ssp*Gs[74])*Hs[117];
	Nxc_sp_s[120]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[80]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[81]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[80] - pow(pow(E,yss[1]),oomega)*Gs[81])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[88]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[47] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[80] - pow(pow(E,yss[1]),oomega)*Gs[81])) - pow(E,yss[8])*Gs[88] + Hs[47]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[80] - pow(pow(E,yss[1]),oomega)*Gs[81])*Hs[119] + (Pssp*Hs[47]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxc_sp_s[121]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[82]*Gs[226] - (pbar*pphi*Pssp*Gs[89]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[85]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[42] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[42] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[43] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[43] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[42]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[43]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[42]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[43]*Hs[115] + (pbar*pphi*Pssp*Gs[89]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[88]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[88]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[85]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[88]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[44]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[44]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[81]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[82] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[43] - pbar*Hs[44]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nxc_sp_s[122]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[81]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[82]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[89]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[85]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[42] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[43] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[43] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[42]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[43]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[42]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[43]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[89]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[88]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[88]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[85]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[88]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[87]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[87]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[81]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[81] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[82] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[42] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[43] - pow(E,yss[7])*pphi*Gs[87]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[85]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[89] - Gs[88]*yss[9]))) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nxc_sp_s[123]=-(pow(E,yss[8])*Pssp*Gs[88]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[43])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[85]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[85]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[8]*Hs[40]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[41]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[42]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[43]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[44]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[45]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[46]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[47]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[40]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[264]*Hs[41]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[42]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[43]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[44]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[45]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[46]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[47]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[40]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[41]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[520]*Hs[42]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[43]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[44]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[45]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[46]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[47]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[40]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[41]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[42]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[43]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[776]*Hs[43]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[44]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[45]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[46]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[47]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[40]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[41]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[42]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[43]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1032]*Hs[44]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[45]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[46]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[47]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[40]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[41]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[42]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[43]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[44]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1288]*Hs[45]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[46]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[47]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[40]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[41]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[42]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[43]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[44]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[45]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1544]*Hs[46]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[47]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[40]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[41]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[42]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[43]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[44]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[45]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[46]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1800]*Hs[47]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[43]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[85])/pow(zbar,rrho) - pow(E,yss[8])*Gs[88] + Gs[89] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[43]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nxc_sp_s[124]=-(kkappa*Pssp*Gs[89]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[88]*Gs[232] - kkappa*Pssp*Gs[86]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[40]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[40]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1]*Hs[40]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[2]*Hs[40]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[4]*Hs[40]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[8]*Hs[40]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[41]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[41]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[41]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[41]*Hs[112])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[42]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[42]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[42]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[42]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[42]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[43]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[43]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[43]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[43]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[43]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[44]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[44]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[44]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[44]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[45]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[45]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[45]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[45]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[46]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[46]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[46]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[46]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[47]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[47]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[47]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[47]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[40]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[40]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[40]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[40]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[257]*Hs[41]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[258]*Hs[41]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[260]*Hs[41]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[264]*Hs[41]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[42]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[42]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[42]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[42]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[43]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[43]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[43]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[43]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[44]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[44]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[44]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[44]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[45]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[45]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[45]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[45]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[46]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[46]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[46]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[46]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[47]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[47]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[47]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[47]*Hs[113])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[40]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[40]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[40]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[40]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[40]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[41]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[41]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[41]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[41]*Hs[114])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[42]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[513]*Hs[42]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[514]*Hs[42]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[516]*Hs[42]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[520]*Hs[42]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[43]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[43]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[43]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[43]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[43]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[44]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[44]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[44]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[44]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[45]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[45]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[45]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[45]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[46]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[46]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[46]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[46]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[47]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[47]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[47]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[47]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[40]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[40]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[40]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[40]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[40]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[41]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[41]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[41]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[41]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[42]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[42]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[42]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[42]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[42]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[43]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[43]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[769]*Hs[43]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[770]*Hs[43]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[772]*Hs[43]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[776]*Hs[43]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[44]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[44]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[44]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[44]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[45]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[45]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[45]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[45]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[46]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[46]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[46]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[46]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[47]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[47]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[47]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[47]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[40] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[88]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[40] + Hs[43])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[40]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[40]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[40]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[40]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[41]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[41]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[41]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[41]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[42]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[42]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[42]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[42]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[43]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[43]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[43]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[43]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1025]*Hs[44]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1026]*Hs[44]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1028]*Hs[44]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1032]*Hs[44]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[45]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[45]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[45]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[45]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[46]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[46]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[46]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[46]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[47]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[47]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[47]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[47]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[40]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[40]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[40]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[40]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[41]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[41]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[41]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[41]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[42]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[42]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[42]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[42]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[43]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[43]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[43]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[43]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[44]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[44]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[44]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[44]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1281]*Hs[45]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1282]*Hs[45]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1284]*Hs[45]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1288]*Hs[45]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[46]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[46]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[46]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[46]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[47]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[47]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[47]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[47]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[40]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[40]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[40]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[40]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[41]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[41]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[41]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[41]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[42]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[42]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[42]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[42]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[43]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[43]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[43]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[43]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[44]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[44]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[44]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[44]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[45]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[45]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[45]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[45]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1537]*Hs[46]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1538]*Hs[46]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1540]*Hs[46]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1544]*Hs[46]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[47]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[47]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[47]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[47]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[40]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[40]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[40]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[40]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[41]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[41]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[41]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[41]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[42]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[42]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[42]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[42]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[43]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[43]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[43]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[43]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[44]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[44]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[44]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[44]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[45]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[45]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[45]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[45]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[46]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[46]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[46]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[46]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1793]*Hs[47]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1794]*Hs[47]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1796]*Hs[47]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1800]*Hs[47]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[40]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[42]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[43]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[40]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[42]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[43]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[40]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[43]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[40] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[43]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[86]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[88] - kkappa*Gs[89] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[43])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[40] + Hs[43]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[40] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[40] + Gsp[17]*Hs[41] + Gsp[33]*Hs[42] + Gsp[49]*Hs[43] + Gsp[65]*Hs[44] + Gsp[81]*Hs[45] + Gsp[97]*Hs[46] + Gsp[113]*Hs[47]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[40] + Gsp[18]*Hs[41] + Gsp[34]*Hs[42] + Gsp[50]*Hs[43] + Gsp[66]*Hs[44] + Gsp[82]*Hs[45] + Gsp[98]*Hs[46] + Gsp[114]*Hs[47]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[40] + Gsp[4]*Hs[40] + Gsp[20]*Hs[41] + Gsp[36]*Hs[42] + rrhoz*Hs[43] + Gsp[52]*Hs[43] + Gsp[68]*Hs[44] + Gsp[84]*Hs[45] + Gsp[100]*Hs[46] + Gsp[116]*Hs[47])))/pow(zbar,rrho) - kkappa*Gs[86]*yss[9]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nxc_sp_s[125]=-(Pssp*Gs[86]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[86] + iiota*zbar*(Hs[40] + Hs[43])) + iiota*Pssp*zbar*(Hs[40] + Hs[43])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[126]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[81]*Gs[225] - pow(E,yss[7])*Pssp*Gs[87]*Gs[231] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[81] - pow(E,yss[7])*Gs[87])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nxc_sp_s[127]=-(pow(E,yss[0])*Pssp*Gs[80]*Gs[224]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[82]*Gs[226] - pow(E,yss[3])*Pssp*Gs[83]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[42] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[42] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[43] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[43] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[42]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[43]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[42]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[43]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[82] + Hs[44])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[85]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[46]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[81] + Gs[87])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[82] + Hs[44])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[85]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[41])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[85]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[43]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[85]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[43]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[41]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[43]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[0])*Gs[80]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[81] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[82] - pow(E,yss[3])*Gs[83] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[85] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[42] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[43] - pow(E,yss[2])*pbar*(Gs[82] + Hs[44]) - pow(E,yss[11])*ebar*Hs[46] - pphi*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44]))*yss[5] + (zbar*Gs[85]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[41])/(1 + yss[5]) - (zbar*Hs[43]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nxc_sp_s[128]=pow(E,yss[3])*Pssp*Gs[83]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[83] - pow(E,xss[0])*zbar*(Hs[40] + Hs[43])) - pow(E,xss[0])*Pssp*zbar*(Hs[40] + Hs[43])*(Hs[112] + Hs[115]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[40] + Hs[43])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[129]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[86] + Hs[40] + Hs[43])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[85]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[85]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[41])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[85]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[43]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[85]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[43]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[41]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[43]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[81] + Gs[87])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[82] + Hs[44])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[85]) - Gs[90] + pow(E,xss[0])*kkappa*zbar*(Gs[86] + Hs[40] + Hs[43]) - (zbar*Gs[85]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[41])/(1 + yss[5]) + (zbar*Hs[43]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[81] + Gs[87]) + pow(E,yss[2])*pbar*(Gs[82] + Hs[44]))*(1 + yss[5])) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nxc_sp_s[130]=((-1 + nnus)*Gs[89] + nnus*Gs[90])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nxc_sp_s[131]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[85] - pow(E,bbar - xss[1])*ppsir*Hs[41] + Hs[45]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[41]*Hs[113] + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nxc_sp_s[132]=pow(E,xss[0])*(-(Pssp*Gs[84]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[84] - Hs[40]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(Gs[228] - Hs[112]) + Pssp*Hs[40]*Hs[112]);
	Nxc_sp_s[133]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Gs[225]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[82]*Gs[226] + pow(E,yss[11])*Pssp*Gs[91]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[42] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[42] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[43] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[43] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[81]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[82] + pow(E,yss[11])*Gs[91] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[42] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[43] + pow(E,yss[2])*pbar*(Gs[82] + Hs[44])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[42]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[43]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[81]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[82]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[42]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[43]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[82] + Hs[44])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nxc_sp_s[134]=(Pssp*zbar*(Gs[91] - Hs[43])*Hs[113] + Pssp*zbar*Hs[41]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[91] - Hs[43])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[92] - zbar*Hs[41] + zbar*(Gs[91] - Hs[43])*xss[1]) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[135]=(-(Pssp*zbar*Hs[43]*Hs[113]) - Pssp*zbar*Hs[41]*Hs[115] - Pssp*(-1 + zbar)*Gs[91]*Gs[235]*xss[1] - Pssp*zbar*Hs[43]*Hs[115]*xss[1] + Pssp*zbar*Gs[235]*(Hs[41] + Hs[43]*xss[1]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[93]) + zbar*Hs[41] - (-1 + zbar)*Gs[91]*xss[1] + zbar*Hs[43]*xss[1]) + Pssp*zbar*Gs[91]*(Hs[113] + Hs[115]*xss[1]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[136]=pow(E,yss[0] - yss[11])*Pssp*Gs[80]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[83]*Gs[227] - Pssp*Gs[91]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[91]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[80] + pow(E,yss[3])*Gs[83] - pow(E,yss[11])*Gs[91] + pow(E,yss[11])*ebar*Hs[46]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[80] + pow(E,yss[3])*Gs[83] - pow(E,yss[0])*Gs[91] - pow(E,yss[3])*Gs[91] - pow(E,yss[11])*ebar*Gs[91] + pow(E,yss[11])*Gs[94] + pow(E,yss[11])*ebar*Hs[46]))/pow(E,yss[11]) + ebar*Pssp*Hs[46]*Hs[118] - (Pssp*Gs[91]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[89] + dP1ssp*Gs[90])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nxc_sp_s[137]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[43]) + Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[89]*Hs[115] + Pssp*pow(zbar,rrho)*Gs[89]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]) + Pssp*pow(zbar,rrho)*G2sp[8]*Hs[40]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[24]*Hs[41]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[40]*Hs[42]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[56]*Hs[43]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[72]*Hs[44]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[88]*Hs[45]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[104]*Hs[46]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[120]*Hs[47]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[24]*Hs[40]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[264]*Hs[41]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[280]*Hs[42]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[296]*Hs[43]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[312]*Hs[44]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[328]*Hs[45]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[344]*Hs[46]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[360]*Hs[47]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[40]*Hs[40]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[280]*Hs[41]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[520]*Hs[42]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[536]*Hs[43]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[552]*Hs[44]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[568]*Hs[45]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[584]*Hs[46]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[600]*Hs[47]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[56]*Hs[40]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[296]*Hs[41]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[536]*Hs[42]*Hs[115]*yss[9] - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[43]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[776]*Hs[43]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[792]*Hs[44]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[808]*Hs[45]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[824]*Hs[46]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[840]*Hs[47]*Hs[115]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[72]*Hs[40]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[312]*Hs[41]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[552]*Hs[42]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[792]*Hs[43]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1032]*Hs[44]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[45]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[46]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[47]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[88]*Hs[40]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[328]*Hs[41]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[568]*Hs[42]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[808]*Hs[43]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[44]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1288]*Hs[45]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[46]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[47]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[104]*Hs[40]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[344]*Hs[41]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[584]*Hs[42]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[824]*Hs[43]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[44]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[45]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1544]*Hs[46]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[47]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[120]*Hs[40]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[360]*Hs[41]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[600]*Hs[42]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[840]*Hs[43]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[44]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[45]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[46]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1800]*Hs[47]*Hs[119]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[43]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[40] + Gsp[24]*Hs[41] + Gsp[40]*Hs[42] + Gsp[56]*Hs[43] + Gsp[72]*Hs[44] + Gsp[88]*Hs[45] + Gsp[104]*Hs[46] + Gsp[120]*Hs[47])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(bbeta*pow(E,yss[8])*Gs[95] + pow(zbar,rrho)*Gsp[120]*Hs[47]*yss[9] + pow(zbar,rrho)*(-Gs[89] + Gsp[8]*Hs[40]*yss[9] + Gsp[24]*Hs[41]*yss[9] + Gsp[40]*Hs[42]*yss[9] + (-(rrho*rrhoz) + Gsp[56])*Hs[43]*yss[9] + Gsp[72]*Hs[44]*yss[9] + Gsp[88]*Hs[45]*yss[9] + Gsp[104]*Hs[46]*yss[9])) + (dP2ssp*Gs[89] + dP1ssp*Gs[90])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nxc_sp_s[138]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[42]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[114];
	Nxc_sp_s[139]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[43]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[115];
	Nxc_sp_s[140]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[44]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[116];
	Nxc_sp_s[141]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[47]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[119];
	Nxc_sp_s[142]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[46]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[118];
	Nxc_sp_s[143]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(rrhor - Hs[45]) - (dP2ssp*Gs[89] + dP1ssp*Gs[90])*Hs[117];
	Nxc_sp_s[144]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[96]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[97]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[96] - pow(pow(E,yss[1]),oomega)*Gs[97])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[104]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[55] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[96] - pow(pow(E,yss[1]),oomega)*Gs[97])) - pow(E,yss[8])*Gs[104] + Hs[55]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[96] - pow(pow(E,yss[1]),oomega)*Gs[97])*Hs[119] + (Pssp*Hs[55]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxc_sp_s[145]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[98]*Gs[226] - (pbar*pphi*Pssp*Gs[105]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[101]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[50] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[50] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[51] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[51] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[50]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[51]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[50]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[51]*Hs[115] + (pbar*pphi*Pssp*Gs[105]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[104]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[104]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[101]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[104]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[52]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[52]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[97]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[98] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[51] - pbar*Hs[52]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nxc_sp_s[146]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[97]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[98]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[105]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[101]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[50] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[51] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[51] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[50]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[51]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[50]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[51]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[105]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[104]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[104]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[101]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[104]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[103]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[103]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[97]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[97] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[98] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[50] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[51] - pow(E,yss[7])*pphi*Gs[103]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[101]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[105] - Gs[104]*yss[9]))) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nxc_sp_s[147]=-(pow(E,yss[8])*Pssp*Gs[104]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[51])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[101]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[101]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[8]*Hs[48]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[49]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[50]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[51]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[52]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[53]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[54]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[55]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[48]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[264]*Hs[49]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[50]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[51]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[52]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[53]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[54]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[55]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[48]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[49]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[520]*Hs[50]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[51]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[52]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[53]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[54]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[55]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[48]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[49]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[50]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[51]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[776]*Hs[51]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[52]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[53]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[54]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[55]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[48]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[49]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[50]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[51]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1032]*Hs[52]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[53]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[54]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[55]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[48]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[49]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[50]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[51]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[52]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1288]*Hs[53]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[54]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[55]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[48]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[49]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[50]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[51]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[52]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[53]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1544]*Hs[54]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[55]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[48]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[49]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[50]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[51]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[52]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[53]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[54]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1800]*Hs[55]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[51]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[101])/pow(zbar,rrho) - pow(E,yss[8])*Gs[104] + Gs[105] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[51]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nxc_sp_s[148]=-(kkappa*Pssp*Gs[105]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[104]*Gs[232] - kkappa*Pssp*Gs[102]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[48]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[48]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1]*Hs[48]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[2]*Hs[48]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[4]*Hs[48]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[8]*Hs[48]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[49]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[49]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[49]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[49]*Hs[112])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[50]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[50]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[50]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[50]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[50]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[51]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[51]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[51]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[51]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[51]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[52]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[52]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[52]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[52]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[53]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[53]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[53]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[53]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[54]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[54]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[54]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[54]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[55]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[55]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[55]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[55]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[48]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[48]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[48]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[48]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[257]*Hs[49]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[258]*Hs[49]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[260]*Hs[49]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[264]*Hs[49]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[50]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[50]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[50]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[50]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[51]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[51]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[51]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[51]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[52]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[52]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[52]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[52]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[53]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[53]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[53]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[53]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[54]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[54]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[54]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[54]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[55]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[55]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[55]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[55]*Hs[113])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[48]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[48]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[48]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[48]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[48]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[49]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[49]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[49]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[49]*Hs[114])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[50]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[513]*Hs[50]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[514]*Hs[50]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[516]*Hs[50]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[520]*Hs[50]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[51]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[51]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[51]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[51]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[51]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[52]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[52]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[52]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[52]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[53]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[53]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[53]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[53]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[54]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[54]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[54]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[54]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[55]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[55]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[55]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[55]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[48]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[48]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[48]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[48]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[48]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[49]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[49]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[49]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[49]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[50]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[50]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[50]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[50]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[50]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[51]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[51]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[769]*Hs[51]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[770]*Hs[51]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[772]*Hs[51]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[776]*Hs[51]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[52]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[52]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[52]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[52]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[53]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[53]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[53]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[53]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[54]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[54]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[54]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[54]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[55]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[55]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[55]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[55]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[48] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[104]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[48] + Hs[51])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[48]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[48]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[48]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[48]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[49]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[49]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[49]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[49]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[50]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[50]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[50]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[50]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[51]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[51]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[51]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[51]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1025]*Hs[52]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1026]*Hs[52]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1028]*Hs[52]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1032]*Hs[52]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[53]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[53]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[53]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[53]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[54]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[54]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[54]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[54]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[55]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[55]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[55]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[55]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[48]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[48]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[48]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[48]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[49]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[49]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[49]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[49]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[50]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[50]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[50]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[50]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[51]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[51]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[51]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[51]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1041]*Hs[52]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1042]*Hs[52]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1044]*Hs[52]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1048]*Hs[52]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1281]*Hs[53]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1282]*Hs[53]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1284]*Hs[53]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1288]*Hs[53]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[54]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[54]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[54]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[54]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[55]*Hs[117] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[55]*Hs[117] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[55]*Hs[117] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[55]*Hs[117])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[48]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[48]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[48]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[48]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[49]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[49]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[49]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[49]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[50]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[50]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[50]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[50]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[51]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[51]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[51]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[51]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1057]*Hs[52]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1058]*Hs[52]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1060]*Hs[52]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1064]*Hs[52]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1297]*Hs[53]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1298]*Hs[53]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1300]*Hs[53]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1304]*Hs[53]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1537]*Hs[54]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1538]*Hs[54]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1540]*Hs[54]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1544]*Hs[54]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[55]*Hs[118] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[55]*Hs[118] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[55]*Hs[118] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[55]*Hs[118])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[48]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[48]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[48]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[48]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[49]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[49]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[49]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[49]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[50]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[50]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[50]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[50]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[51]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[51]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[51]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[51]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1073]*Hs[52]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1074]*Hs[52]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1076]*Hs[52]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1080]*Hs[52]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1313]*Hs[53]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1314]*Hs[53]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1316]*Hs[53]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1320]*Hs[53]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1553]*Hs[54]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1554]*Hs[54]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1556]*Hs[54]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1560]*Hs[54]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1793]*Hs[55]*Hs[119] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1794]*Hs[55]*Hs[119] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1796]*Hs[55]*Hs[119] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1800]*Hs[55]*Hs[119])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[48]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[50]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[51]*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55])*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*Hs[48]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[50]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[51]*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55])*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[48]*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*(Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])*(Gsp[228] + Gsp[4]*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + (rrhoz + Gsp[52])*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119]) + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[51]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[48] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55]))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*Hs[51]*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*Pssp*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Pssp*Gs[102]*Gs[230]*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[8])*Gs[104] - kkappa*Gs[105] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[51])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[48] + Hs[51]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[48] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[48] + Gsp[17]*Hs[49] + Gsp[33]*Hs[50] + Gsp[49]*Hs[51] + Gsp[65]*Hs[52] + Gsp[81]*Hs[53] + Gsp[97]*Hs[54] + Gsp[113]*Hs[55]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[48] + Gsp[18]*Hs[49] + Gsp[34]*Hs[50] + Gsp[50]*Hs[51] + Gsp[66]*Hs[52] + Gsp[82]*Hs[53] + Gsp[98]*Hs[54] + Gsp[114]*Hs[55]) + pow(E,xss[0])*iiota*pow(zbar,2)*(-Hs[48] + Gsp[4]*Hs[48] + Gsp[20]*Hs[49] + Gsp[36]*Hs[50] + rrhoz*Hs[51] + Gsp[52]*Hs[51] + Gsp[68]*Hs[52] + Gsp[84]*Hs[53] + Gsp[100]*Hs[54] + Gsp[116]*Hs[55])))/pow(zbar,rrho) - kkappa*Gs[102]*yss[9]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[8])*Gs[232] - kkappa*Gs[233] + (bbeta*pow(E,yss[8])*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*zbar*(Hs[112] + Hs[115]) - (bbeta*pow(E,yss[8])*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) - (bbeta*pow(E,-xss[0] + yss[8])*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[112] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[225] + Gsp[1]*Hs[112] + Gsp[17]*Hs[113] + Gsp[33]*Hs[114] + Gsp[49]*Hs[115] + Gsp[65]*Hs[116] + Gsp[81]*Hs[117] + Gsp[97]*Hs[118] + Gsp[113]*Hs[119]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[226] + Gsp[2]*Hs[112] + Gsp[18]*Hs[113] + Gsp[34]*Hs[114] + Gsp[50]*Hs[115] + Gsp[66]*Hs[116] + Gsp[82]*Hs[117] + Gsp[98]*Hs[118] + Gsp[114]*Hs[119]) + pow(E,xss[0])*iiota*pow(zbar,2)*(Gsp[228] + (-1 + Gsp[4])*Hs[112] + Gsp[20]*Hs[113] + Gsp[36]*Hs[114] + rrhoz*Hs[115] + Gsp[52]*Hs[115] + Gsp[68]*Hs[116] + Gsp[84]*Hs[117] + Gsp[100]*Hs[118] + Gsp[116]*Hs[119])))/pow(zbar,rrho) - kkappa*Gs[230]*yss[9]);
	Nxc_sp_s[149]=-(Pssp*Gs[102]*Gs[230]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[102] + iiota*zbar*(Hs[48] + Hs[51])) + iiota*Pssp*zbar*(Hs[48] + Hs[51])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-Gs[230] + iiota*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[150]=pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[97]*Gs[225] - pow(E,yss[7])*Pssp*Gs[103]*Gs[231] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225] - pow(E,yss[7])*Gs[231]) + (pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[97] - pow(E,yss[7])*Gs[103])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]);
	Nxc_sp_s[151]=-(pow(E,yss[0])*Pssp*Gs[96]*Gs[224]) + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Gs[225] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Gs[226] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[98]*Gs[226] - pow(E,yss[3])*Pssp*Gs[99]*Gs[227] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[50] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[50] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[51] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[51] - pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52])) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[114] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[50]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[51]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[115] - aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[50]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[51]*Hs[115] - pow(E,yss[2])*pbar*Pssp*(Gs[98] + Hs[52])*(Gs[226] + Hs[116]) - pphi*Pssp*Gs[101]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) - pow(E,yss[11])*ebar*Pssp*Hs[54]*Hs[118] - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[97] + Gs[103])*(Gs[225] + Gs[231])*yss[5] - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[98] + Hs[52])*(Gs[226] + Hs[116])*yss[5] - (2*Pssp*zbar*Gs[101]*Gs[229]*xss[1])/pow(1 + yss[5],3) + (Pssp*zbar*Gs[229]*Hs[49])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[101]*Hs[113])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[229]*Hs[51]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Gs[101]*Hs[115]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Hs[51]*Hs[113])/(1 + yss[5]) - (Pssp*zbar*Hs[49]*Hs[115])/(1 + yss[5]) - (Pssp*zbar*Hs[51]*Hs[115]*xss[1])/(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[0])*Gs[96]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[97] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[98] - pow(E,yss[3])*Gs[99] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[101] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[50] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[51] - pow(E,yss[2])*pbar*(Gs[98] + Hs[52]) - pow(E,yss[11])*ebar*Hs[54] - pphi*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52]))*yss[5] + (zbar*Gs[101]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[49])/(1 + yss[5]) - (zbar*Hs[51]*xss[1])/(1 + yss[5])) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(pow(E,yss[0])*Gs[224]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - pow(E,yss[3])*Gs[227] - (pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[2])*pbar*(Gs[226] + Hs[116]) - pow(E,yss[11])*ebar*Hs[118] - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*yss[5] + (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) - (zbar*Hs[113])/(1 + yss[5]) - (zbar*Hs[115]*xss[1])/(1 + yss[5]));
	Nxc_sp_s[152]=pow(E,yss[3])*Pssp*Gs[99]*Gs[227] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[3])*Gs[99] - pow(E,xss[0])*zbar*(Hs[48] + Hs[51])) - pow(E,xss[0])*Pssp*zbar*(Hs[48] + Hs[51])*(Hs[112] + Hs[115]) - pow(E,xss[0])*iiota*Pssp*pow(zbar,2)*(Hs[48] + Hs[51])*(Hs[112] + Hs[115]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[3])*Gs[227] - pow(E,xss[0])*zbar*(Hs[112] + Hs[115]));
	Nxc_sp_s[153]=-(pphi*Pssp*Gs[229]*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52]))) + pow(E,xss[0])*kkappa*Pssp*zbar*(Gs[102] + Hs[48] + Hs[51])*(Gs[230] + Hs[112] + Hs[115]) - pphi*Pssp*Gs[101]*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116])) + (2*Pssp*zbar*Gs[101]*Gs[229]*xss[1])/pow(1 + yss[5],3) - (Pssp*zbar*Gs[229]*Hs[49])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[101]*Hs[113])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[229]*Hs[51]*xss[1])/pow(1 + yss[5],2) - (Pssp*zbar*Gs[101]*Hs[115]*xss[1])/pow(1 + yss[5],2) + (Pssp*zbar*Hs[51]*Hs[113])/(1 + yss[5]) + (Pssp*zbar*Hs[49]*Hs[115])/(1 + yss[5]) + (Pssp*zbar*Hs[51]*Hs[115]*xss[1])/(1 + yss[5]) - pow(E,yss[1] + yss[7])*pphi*Pssp*(Gs[97] + Gs[103])*(Gs[225] + Gs[231])*(1 + yss[5]) - pow(E,yss[2])*pbar*pphi*Pssp*(Gs[98] + Hs[52])*(Gs[226] + Hs[116])*(1 + yss[5]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[101]) - Gs[106] + pow(E,xss[0])*kkappa*zbar*(Gs[102] + Hs[48] + Hs[51]) - (zbar*Gs[101]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[49])/(1 + yss[5]) + (zbar*Hs[51]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[97] + Gs[103]) + pow(E,yss[2])*pbar*(Gs[98] + Hs[52]))*(1 + yss[5])) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-((pow(E,yss[1] + yss[7]) + pow(E,yss[2])*pbar)*pphi*Gs[229]) - Gs[234] + pow(E,xss[0])*kkappa*zbar*(Gs[230] + Hs[112] + Hs[115]) - (zbar*Gs[229]*xss[1])/pow(1 + yss[5],2) + (zbar*Hs[113])/(1 + yss[5]) + (zbar*Hs[115]*xss[1])/(1 + yss[5]) - pphi*(pow(E,yss[1] + yss[7])*(Gs[225] + Gs[231]) + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]))*(1 + yss[5]));
	Nxc_sp_s[154]=((-1 + nnus)*Gs[105] + nnus*Gs[106])*(dP2ssp*Gs[233] + dP1ssp*Gs[234]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*((-1 + nnus)*Gs[233] + nnus*Gs[234] + (-varphibar + varphis)*yss[9] + (-varphibar + varphis)*yss[10]);
	Nxc_sp_s[155]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-Gs[101] - pow(E,bbar - xss[1])*ppsir*Hs[49] + Hs[53]) + pow(E,bbar - xss[1])*ppsir*Pssp*Hs[49]*Hs[113] + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-Gs[229] - pow(E,bbar - xss[1])*ppsir*Hs[113] + Hs[117]);
	Nxc_sp_s[156]=pow(E,xss[0])*(-(Pssp*Gs[100]*Gs[228]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(Gs[100] - Hs[48]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(Gs[228] - Hs[112]) + Pssp*Hs[48]*Hs[112]);
	Nxc_sp_s[157]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Gs[225]) + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Gs[225] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Gs[226] - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[98]*Gs[226] + pow(E,yss[11])*Pssp*Gs[107]*Gs[235] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[50] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[50] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[51] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[51] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[97]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[98] + pow(E,yss[11])*Gs[107] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[50] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[51] + pow(E,yss[2])*pbar*(Gs[98] + Hs[52])) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[114] + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[50]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[51]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[97]*Hs[115] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[98]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[50]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[51]*Hs[115] + pow(E,yss[2])*pbar*Pssp*(Gs[98] + Hs[52])*(Gs[226] + Hs[116]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[226] + pow(E,yss[11])*Gs[235] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] + pow(E,yss[2])*pbar*(Gs[226] + Hs[116]));
	Nxc_sp_s[158]=(Pssp*zbar*(Gs[107] - Hs[51])*Hs[113] + Pssp*zbar*Hs[49]*(Gs[235] - Hs[115]) - Pssp*zbar*(Gs[107] - Hs[51])*(Gs[235] - Hs[115])*xss[1] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[11])*Gs[108] - zbar*Hs[49] + zbar*(Gs[107] - Hs[51])*xss[1]) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[11])*Gs[236] - zbar*Hs[113] + zbar*(Gs[235] - Hs[115])*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[159]=(-(Pssp*zbar*Hs[51]*Hs[113]) - Pssp*zbar*Hs[49]*Hs[115] - Pssp*(-1 + zbar)*Gs[107]*Gs[235]*xss[1] - Pssp*zbar*Hs[51]*Hs[115]*xss[1] + Pssp*zbar*Gs[235]*(Hs[49] + Hs[51]*xss[1]) - (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(E,yss[11])*Gs[109]) + zbar*Hs[49] - (-1 + zbar)*Gs[107]*xss[1] + zbar*Hs[51]*xss[1]) + Pssp*zbar*Gs[107]*(Hs[113] + Hs[115]*xss[1]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(-(pow(E,yss[11])*Gs[237]) + zbar*Hs[113] - (-1 + zbar)*Gs[235]*xss[1] + zbar*Hs[115]*xss[1]))/pow(E,yss[11]);
	Nxc_sp_s[160]=pow(E,yss[0] - yss[11])*Pssp*Gs[96]*Gs[224] + pow(E,yss[3] - yss[11])*Pssp*Gs[99]*Gs[227] - Pssp*Gs[107]*Gs[235] + ((pow(E,yss[0]) + pow(E,yss[3]) + pow(E,yss[11])*(-1 + ebar))*Pssp*Gs[107]*Gs[235])/pow(E,yss[11]) - (Pssp*Gs[235]*(pow(E,yss[0])*Gs[96] + pow(E,yss[3])*Gs[99] - pow(E,yss[11])*Gs[107] + pow(E,yss[11])*ebar*Hs[54]))/pow(E,yss[11]) + ((dP2ssp*Gs[233] + dP1ssp*Gs[234])*(pow(E,yss[0])*Gs[96] + pow(E,yss[3])*Gs[99] - pow(E,yss[0])*Gs[107] - pow(E,yss[3])*Gs[107] - pow(E,yss[11])*ebar*Gs[107] + pow(E,yss[11])*Gs[110] + pow(E,yss[11])*ebar*Hs[54]))/pow(E,yss[11]) + ebar*Pssp*Hs[54]*Hs[118] - (Pssp*Gs[107]*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[11])*Gs[235] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]) + ((dP2ssp*Gs[105] + dP1ssp*Gs[106])*(pow(E,yss[0])*Gs[224] + pow(E,yss[3])*Gs[227] - pow(E,yss[0])*Gs[235] - pow(E,yss[3])*Gs[235] - pow(E,yss[11])*ebar*Gs[235] + pow(E,yss[11])*Gs[238] + pow(E,yss[11])*ebar*Hs[118]))/pow(E,yss[11]);
	Nxc_sp_s[161]=(-(Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[233]*Hs[51]) + Pssp*pow(zbar,rrho)*Gs[233]*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55]) - Pssp*rrho*rrhoz*pow(zbar,rrho)*Gs[105]*Hs[115] + Pssp*pow(zbar,rrho)*Gs[105]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]) + Pssp*pow(zbar,rrho)*G2sp[8]*Hs[48]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[24]*Hs[49]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[40]*Hs[50]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[56]*Hs[51]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[72]*Hs[52]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[88]*Hs[53]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[104]*Hs[54]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[120]*Hs[55]*Hs[112]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[24]*Hs[48]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[264]*Hs[49]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[280]*Hs[50]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[296]*Hs[51]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[312]*Hs[52]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[328]*Hs[53]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[344]*Hs[54]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[360]*Hs[55]*Hs[113]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[40]*Hs[48]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[280]*Hs[49]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[520]*Hs[50]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[536]*Hs[51]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[552]*Hs[52]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[568]*Hs[53]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[584]*Hs[54]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[600]*Hs[55]*Hs[114]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[56]*Hs[48]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[296]*Hs[49]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[536]*Hs[50]*Hs[115]*yss[9] - Pssp*pow(rrho,2)*pow(rrhoz,2)*pow(zbar,rrho)*Hs[51]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[776]*Hs[51]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[792]*Hs[52]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[808]*Hs[53]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[824]*Hs[54]*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[840]*Hs[55]*Hs[115]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*Hs[115]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[72]*Hs[48]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[312]*Hs[49]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[552]*Hs[50]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[792]*Hs[51]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1032]*Hs[52]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[53]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[54]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[55]*Hs[116]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[88]*Hs[48]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[328]*Hs[49]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[568]*Hs[50]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[808]*Hs[51]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1048]*Hs[52]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1288]*Hs[53]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[54]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[55]*Hs[117]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[104]*Hs[48]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[344]*Hs[49]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[584]*Hs[50]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[824]*Hs[51]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1064]*Hs[52]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1304]*Hs[53]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1544]*Hs[54]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[55]*Hs[118]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[120]*Hs[48]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[360]*Hs[49]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[600]*Hs[50]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[840]*Hs[51]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1080]*Hs[52]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1320]*Hs[53]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1560]*Hs[54]*Hs[119]*yss[9] + Pssp*pow(zbar,rrho)*G2sp[1800]*Hs[55]*Hs[119]*yss[9] + Pssp*rrho*rrhoz*pow(zbar,rrho)*Hs[51]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] - Pssp*pow(zbar,rrho)*(Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[56]*Hs[51] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54] + Gsp[120]*Hs[55])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(bbeta*pow(E,yss[8])*Gs[111] + pow(zbar,rrho)*Gsp[120]*Hs[55]*yss[9] + pow(zbar,rrho)*(-Gs[105] + (-(rrho*rrhoz) + Gsp[56])*Hs[51]*yss[9] + (Gsp[8]*Hs[48] + Gsp[24]*Hs[49] + Gsp[40]*Hs[50] + Gsp[72]*Hs[52] + Gsp[88]*Hs[53] + Gsp[104]*Hs[54])*yss[9])) + (dP2ssp*Gs[105] + dP1ssp*Gs[106])*(bbeta*pow(E,yss[8])*Gs[239] + pow(zbar,rrho)*(-Gs[233] + (-(rrho*rrhoz) + Gsp[56])*Hs[115]*yss[9] + (Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*yss[9])))/(bbeta*pow(E,yss[8]));
	Nxc_sp_s[162]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[50]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[114];
	Nxc_sp_s[163]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[51]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[115];
	Nxc_sp_s[164]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[52]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[116];
	Nxc_sp_s[165]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[55]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[119];
	Nxc_sp_s[166]=(dP2ssp*Gs[233] + dP1ssp*Gs[234])*(rrhoe - Hs[54]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[118];
	Nxc_sp_s[167]=-((dP2ssp*Gs[233] + dP1ssp*Gs[234])*Hs[53]) - (dP2ssp*Gs[105] + dP1ssp*Gs[106])*Hs[117];
	Nxc_sp_s[168]=-(pow(E,yss[0])*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*Gs[112]*Gs[224]) + pow(pow(E,yss[1]),oomega)*pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*oomega*Pssp*rrho*Gs[113]*Gs[225] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-2 - rrho)*Pssp*(-1 - rrho)*rrho*(pow(E,yss[0])*Gs[112] - pow(pow(E,yss[1]),oomega)*Gs[113])*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225]) - pow(E,yss[8])*Pssp*Gs[120]*Gs[232] - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])*Hs[63] + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[112] - pow(pow(E,yss[1]),oomega)*Gs[113])) - pow(E,yss[8])*Gs[120] + Hs[63]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho)) - pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*Pssp*rrho*(pow(E,yss[0])*Gs[112] - pow(pow(E,yss[1]),oomega)*Gs[113])*Hs[119] + (Pssp*Hs[63]*Hs[119])/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,-1 - rrho)*rrho*(pow(E,yss[0])*Gs[224] - pow(pow(E,yss[1]),oomega)*Gs[225])) - pow(E,yss[8])*Gs[232] + Hs[119]/pow(pow(E,yss[0]) - pow(pow(E,yss[1]),oomega)/oomega,rrho));
	Nxc_sp_s[169]=-(pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Gs[225]) + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[114]*Gs[226] - (pbar*pphi*Pssp*Gs[121]*Gs[229])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[117]*Gs[233])/pow(E,yss[8]) - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[58] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[58] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[59] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[59] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[114] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[58]*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[59]*Hs[114] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[115] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[115] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[58]*Hs[115] - pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha)*Hs[59]*Hs[115] + (pbar*pphi*Pssp*Gs[121]*Gs[232]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[120]*Gs[233]*(1 + yss[5]))/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[120]*Gs[229]*yss[9])/pow(E,yss[8]) + (pbar*pphi*Pssp*Gs[117]*Gs[232]*yss[9])/pow(E,yss[8]) - (pbar*pphi*Pssp*Gs[120]*Gs[232]*(1 + yss[5])*yss[9])/pow(E,yss[8]) - pbar*Pssp*Hs[60]*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*Pssp*Hs[116]*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])))/pow(E,yss[8]) - (pbar*pphi*Pssp*Hs[60]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[113]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[114] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[58] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[59] - pbar*Hs[60]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])))/pow(E,yss[8])) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Gs[225]) + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*(aalpha + eeta)*pow(zbar,aalpha)*Gs[226] - abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[114] - aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + aalpha + eeta)*pow(zbar,aalpha)*Hs[115] - pbar*Hs[116]*(1 + pphi*yss[5] + (pphi*(1 + yss[5])*yss[9])/pow(E,yss[8])) - (pbar*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])))/pow(E,yss[8]));
	Nxc_sp_s[170]=-(pow(pow(E,yss[1]),-1 + oomega)*pow(-1 + oomega,2)*Pssp*Gs[113]*Gs[225]) + pow(-1 + aalpha,2)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Gs[225] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Gs[226] + aalpha*abar*pow(E,-yss[1] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + aalpha + eeta,2)*Pssp*pow(zbar,aalpha)*Gs[114]*Gs[226] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[121]*Gs[229] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[117]*Gs[233] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[58] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[225]*Hs[59] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[226]*Hs[59] + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[58]*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[59]*Hs[114] + (-1 + aalpha)*pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[113]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Gs[114]*Hs[115] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[58]*Hs[115] + pow(aalpha,3)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*Pssp*pow(zbar,aalpha)*Hs[59]*Hs[115] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[121]*Gs[232]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[120]*Gs[233]*(1 + yss[5]) + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[120]*Gs[229]*yss[9] + pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[117]*Gs[232]*yss[9] - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[120]*Gs[232]*(1 + yss[5])*yss[9] - pow(E,yss[7])*pphi*Pssp*Gs[119]*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[231]*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9])) - pow(E,yss[7] - yss[8])*pphi*Pssp*Gs[119]*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[113]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[113] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[114] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[58] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[59] - pow(E,yss[7])*pphi*Gs[119]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[117]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[121] - Gs[120]*yss[9]))) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*(-(pow(pow(E,yss[1]),-1 + oomega)*(-1 + oomega)*Gs[225]) + (-1 + aalpha)*aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[225] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*(1 - aalpha - eeta)*pow(zbar,aalpha)*Gs[226] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[114] + pow(aalpha,2)*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),-1 + aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*pow(zbar,aalpha)*Hs[115] - pow(E,yss[7])*pphi*Gs[231]*(yss[5] + ((1 + yss[5])*yss[9])/pow(E,yss[8])) - pow(E,yss[7] - yss[8])*pphi*(Gs[229]*(pow(E,yss[8]) + yss[9]) + (1 + yss[5])*(Gs[233] - Gs[232]*yss[9])));
	Nxc_sp_s[171]=-(pow(E,yss[8])*Pssp*Gs[120]*Gs[232]) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[229]*Hs[59])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[229]*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Gs[117]*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*Gs[117]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[8]*Hs[56]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[57]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[58]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[59]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[60]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[61]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[62]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[63]*Hs[112]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[24]*Hs[56]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[264]*Hs[57]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[58]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[59]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[60]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[61]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[62]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[63]*Hs[113]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[40]*Hs[56]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[280]*Hs[57]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[520]*Hs[58]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[59]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[60]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[61]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[62]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[63]*Hs[114]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[56]*Hs[56]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[296]*Hs[57]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[536]*Hs[58]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*Hs[59]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[776]*Hs[59]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[60]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[61]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[62]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[63]*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[72]*Hs[56]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[312]*Hs[57]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[552]*Hs[58]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[792]*Hs[59]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1032]*Hs[60]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[61]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[62]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[63]*Hs[116]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[88]*Hs[56]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[328]*Hs[57]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[568]*Hs[58]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[808]*Hs[59]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1048]*Hs[60]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1288]*Hs[61]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[62]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[63]*Hs[117]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[104]*Hs[56]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[344]*Hs[57]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[584]*Hs[58]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[824]*Hs[59]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1064]*Hs[60]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1304]*Hs[61]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1544]*Hs[62]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[63]*Hs[118]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[120]*Hs[56]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[360]*Hs[57]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[600]*Hs[58]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[840]*Hs[59]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1080]*Hs[60]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1320]*Hs[61]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1560]*Hs[62]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*G2sp[1800]*Hs[63]*Hs[119]*(1 + yss[5]))/pow(zbar,rrho) - (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*Hs[59]*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*Pssp*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho) + (dP2ssp*Gs[233] + dP1ssp*Gs[234])*((bbeta*pow(E,yss[8])*Gs[117])/pow(zbar,rrho) - pow(E,yss[8])*Gs[120] + Gs[121] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[59]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*(1 + yss[5]))/pow(zbar,rrho)) + (dP2ssp*Gs[121] + dP1ssp*Gs[122])*((bbeta*pow(E,yss[8])*Gs[229])/pow(zbar,rrho) - pow(E,yss[8])*Gs[232] + Gs[233] - (bbeta*pow(E,yss[8])*rrho*rrhoz*Hs[115]*(1 + yss[5]))/pow(zbar,rrho) + (bbeta*pow(E,yss[8])*(Gsp[232] + Gsp[8]*Hs[112] + Gsp[24]*Hs[113] + Gsp[40]*Hs[114] + Gsp[56]*Hs[115] + Gsp[72]*Hs[116] + Gsp[88]*Hs[117] + Gsp[104]*Hs[118] + Gsp[120]*Hs[119])*(1 + yss[5]))/pow(zbar,rrho));
	Nxc_sp_s[172]=-(kkappa*Pssp*Gs[121]*Gs[230]) + pow(E,yss[8])*Pssp*Gs[120]*Gs[232] - kkappa*Pssp*Gs[118]*Gs[233] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*Hs[56]*Hs[112] - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*pow(-1 + eeta,2)*eeta*Pssp*pow(zbar,aalpha - rrho)*Hs[56]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1]*Hs[56]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[2]*Hs[56]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[4]*Hs[56]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[8]*Hs[56]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[57]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[57]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[57]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[57]*Hs[112])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[58]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[58]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[58]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[58]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[58]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[59]*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[59]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[59]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[59]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[59]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[60]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[60]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[60]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[60]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[81]*Hs[61]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[82]*Hs[61]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[84]*Hs[61]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[88]*Hs[61]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[97]*Hs[62]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[98]*Hs[62]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[100]*Hs[62]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[104]*Hs[62]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[113]*Hs[63]*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[114]*Hs[63]*Hs[112] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[116]*Hs[63]*Hs[112] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[120]*Hs[63]*Hs[112])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63])*Hs[112] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63])*Hs[112] + bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63])*Hs[112] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[17]*Hs[56]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[18]*Hs[56]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[20]*Hs[56]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[24]*Hs[56]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[257]*Hs[57]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[258]*Hs[57]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[260]*Hs[57]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[264]*Hs[57]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[58]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[58]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[58]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[58]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[59]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[59]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[59]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[59]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[60]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[60]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[60]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[60]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[321]*Hs[61]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[322]*Hs[61]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[324]*Hs[61]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[328]*Hs[61]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[337]*Hs[62]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[338]*Hs[62]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[340]*Hs[62]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[344]*Hs[62]*Hs[113])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[353]*Hs[63]*Hs[113] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[354]*Hs[63]*Hs[113] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[356]*Hs[63]*Hs[113] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[360]*Hs[63]*Hs[113])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*Hs[56]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[33]*Hs[56]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[34]*Hs[56]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[36]*Hs[56]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[40]*Hs[56]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[273]*Hs[57]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[274]*Hs[57]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[276]*Hs[57]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[280]*Hs[57]*Hs[114])/pow(zbar,rrho) - abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoa,2)*pow(zbar,aalpha - rrho)*Hs[58]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[513]*Hs[58]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[514]*Hs[58]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[516]*Hs[58]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[520]*Hs[58]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[59]*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[59]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[59]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[59]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[59]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[60]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[60]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[60]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[60]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[561]*Hs[61]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[562]*Hs[61]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[564]*Hs[61]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[568]*Hs[61]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[577]*Hs[62]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[578]*Hs[62]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[580]*Hs[62]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[584]*Hs[62]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[593]*Hs[63]*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[594]*Hs[63]*Hs[114] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[596]*Hs[63]*Hs[114] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[600]*Hs[63]*Hs[114])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63])*Hs[114] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoa*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63])*Hs[114] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*Hs[56]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[49]*Hs[56]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[50]*Hs[56]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[52]*Hs[56]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[56]*Hs[56]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[289]*Hs[57]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[290]*Hs[57]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[292]*Hs[57]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[296]*Hs[57]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoa*rrhoz*pow(zbar,aalpha - rrho)*Hs[58]*Hs[115] - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[529]*Hs[58]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[530]*Hs[58]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[532]*Hs[58]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[536]*Hs[58]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(rrhoz,2)*pow(zbar,aalpha - rrho)*Hs[59]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*pow(rrho,2)*pow(rrhoz,2)*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*Hs[59]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[769]*Hs[59]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[770]*Hs[59]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[772]*Hs[59]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[776]*Hs[59]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[60]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[60]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[60]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[60]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[801]*Hs[61]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[802]*Hs[61]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[804]*Hs[61]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[808]*Hs[61]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[817]*Hs[62]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[818]*Hs[62]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[820]*Hs[62]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[824]*Hs[62]*Hs[115])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[833]*Hs[63]*Hs[115] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[834]*Hs[63]*Hs[115] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[836]*Hs[63]*Hs[115] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[840]*Hs[63]*Hs[115])/pow(zbar,rrho) - pow(aalpha,2)*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63])*Hs[115] + aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*rrhoz*pow(zbar,aalpha - rrho)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63])*Hs[115] + (bbeta*pow(E,yss[8])*Pssp*rrho*rrhoz*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*(Gsp[8]*Hs[56] + Gsp[24]*Hs[57] + Gsp[40]*Hs[58] + Gsp[56]*Hs[59] + Gsp[72]*Hs[60] + Gsp[88]*Hs[61] + Gsp[104]*Hs[62] + Gsp[120]*Hs[63])*Hs[115])/pow(zbar,rrho) + (bbeta*pow(E,-xss[0] + yss[8])*Pssp*rrho*rrhoz*(abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*(-1 + eeta)*eeta*pow(zbar,aalpha)*Hs[56] + abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoa*pow(zbar,aalpha)*Hs[58] + aalpha*abar*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),1 - aalpha - eeta)*eeta*rrhoz*pow(zbar,aalpha)*Hs[59] + aalpha*abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha)*(Gsp[1]*Hs[56] + Gsp[17]*Hs[57] + Gsp[33]*Hs[58] + Gsp[49]*Hs[59] + Gsp[65]*Hs[60] + Gsp[81]*Hs[61] + Gsp[97]*Hs[62] + Gsp[113]*Hs[63]) - abar*pow(E,yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*pow(zbar,aalpha)*(Gsp[2]*Hs[56] + Gsp[18]*Hs[57] + Gsp[34]*Hs[58] + Gsp[50]*Hs[59] + Gsp[66]*Hs[60] + Gsp[82]*Hs[61] + Gsp[98]*Hs[62] + Gsp[114]*Hs[63]) + pow(E,xss[0])*iiota*pow(zbar,2)*((-1 + Gsp[4])*Hs[56] + Gsp[20]*Hs[57] + Gsp[36]*Hs[58] + rrhoz*Hs[59] + Gsp[52]*Hs[59] + Gsp[68]*Hs[60] + Gsp[84]*Hs[61] + Gsp[100]*Hs[62] + Gsp[116]*Hs[63]))*Hs[115])/pow(zbar,rrho) + pow(E,yss[8])*iiota*Pssp*zbar*Gs[120]*(Hs[112] + Hs[115]) + pow(E,yss[8])*iiota*Pssp*zbar*(Hs[56] + Hs[59])*(Gs[232] + Hs[112] + Hs[115]) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[65]*Hs[56]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[66]*Hs[56]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[68]*Hs[56]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[72]*Hs[56]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[305]*Hs[57]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[306]*Hs[57]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[308]*Hs[57]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[312]*Hs[57]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[545]*Hs[58]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[546]*Hs[58]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[548]*Hs[58]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[552]*Hs[58]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[785]*Hs[59]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[786]*Hs[59]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[788]*Hs[59]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[792]*Hs[59]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*Pssp*pow(zbar,aalpha - rrho)*G2sp[1025]*Hs[60]*Hs[116] + abar*bbeta*pow(E,-xss[0] + yss[2] + yss[8])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*(-1 + aalpha + eeta)*Pssp*pow(zbar,aalpha - rrho)*G2sp[1026]*Hs[60]*Hs[116] - bbeta*pow(E,yss[8])*iiota*Pssp*pow(zbar,2 - rrho)*G2sp[1028]*Hs[60]*Hs[116] - (bbeta*pow(E,yss[8])*Pssp*(1 - ddelta + abar*pow(E,-xss[0] + yss[2])*pow(pow(E,xss[0]),eeta)*pow(pow(E,yss[1]),aalpha)*pow(pow(E,yss[2]),-aalpha - eeta)*eeta*pow(zbar,aalpha))*G2sp[1032]*Hs[60]*Hs[116])/pow(zbar,rrho) - aalpha*abar*bbeta*pow(E,-xss[0